/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueEntry;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettings;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettingsService;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.dmz.pull.PreAcceptMergeCheckResult;
import com.atlassian.bitbucket.dmz.pull.PreparedPullRequestMerge;
import com.atlassian.bitbucket.dmz.pull.SimplePreparedPullRequestMerge;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVeto;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mergequeue.CombinedPreAcceptMergeResults;
import com.atlassian.bitbucket.internal.mergequeue.MergeQueueExecutorTask;
import com.atlassian.bitbucket.internal.mergequeue.PreMergeAcceptCheckHelper;
import com.atlassian.bitbucket.internal.mergequeue.concurrent.MergeQueueEntryLock;
import com.atlassian.bitbucket.internal.mergequeue.dao.MergeQueueDao;
import com.atlassian.bitbucket.internal.mergequeue.event.MergeQueueItemEjectedEvent;
import com.atlassian.bitbucket.internal.mergequeue.event.MergeQueueItemProcessedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeVetoedException;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.SimpleBranch;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.DevModeUtils;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.mergequeue.InternalMergeQueueEntry;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class MergeQueueProcessor
implements BucketProcessor<MergeQueueExecutorTask> {
    private static final Logger log = LoggerFactory.getLogger(MergeQueueProcessor.class);
    private final Duration checksTimeout;
    private final Clock clock;
    private final CommitService commitService;
    private final EventPublisher eventPublisher;
    private final GitCommandBuilderFactory gitCommandBuilderFactory;
    private final I18nService i18nService;
    private final MergeQueueDao mergeQueueDao;
    private final MergeQueueEntryLock mergeQueueEntryLock;
    private final MergeQueueSettingsService mergeQueueSettingsService;
    private final PreMergeAcceptCheckHelper preMergeAcceptCheckHelper;
    private final DmzPullRequestService pullRequestService;
    private final RefService refService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;
    private final EscalatedSecurityContext withRepoWrite;

    public MergeQueueProcessor(Duration checksTimeout, CommitService commitService, EventPublisher eventPublisher, GitCommandBuilderFactory gitCommandBuilderFactory, I18nService i18nService, MergeQueueDao mergeQueueDao, MergeQueueEntryLock mergeQueueEntryLock, MergeQueueSettingsService mergeQueueSettingsService, PreMergeAcceptCheckHelper preMergeAcceptCheckHelper, DmzPullRequestService pullRequestService, RefService refService, RepositoryService repositoryService, SecurityService securityService, PlatformTransactionManager transactionManager, UserService userService) {
        this(checksTimeout, Clock.systemUTC(), commitService, eventPublisher, gitCommandBuilderFactory, i18nService, mergeQueueDao, mergeQueueEntryLock, mergeQueueSettingsService, preMergeAcceptCheckHelper, pullRequestService, refService, repositoryService, securityService, transactionManager, userService);
    }

    @VisibleForTesting
    MergeQueueProcessor(Duration checksTimeout, Clock clock, CommitService commitService, EventPublisher eventPublisher, GitCommandBuilderFactory gitCommandBuilderFactory, I18nService i18nService, MergeQueueDao mergeQueueDao, MergeQueueEntryLock mergeQueueEntryLock, MergeQueueSettingsService mergeQueueSettingsService, PreMergeAcceptCheckHelper preMergeAcceptCheckHelper, DmzPullRequestService pullRequestService, RefService refService, RepositoryService repositoryService, SecurityService securityService, PlatformTransactionManager transactionManager, UserService userService) {
        this.checksTimeout = checksTimeout;
        this.clock = clock;
        this.commitService = commitService;
        this.eventPublisher = eventPublisher;
        this.gitCommandBuilderFactory = gitCommandBuilderFactory;
        this.i18nService = i18nService;
        this.mergeQueueDao = mergeQueueDao;
        this.mergeQueueEntryLock = mergeQueueEntryLock;
        this.mergeQueueSettingsService = mergeQueueSettingsService;
        this.preMergeAcceptCheckHelper = preMergeAcceptCheckHelper;
        this.pullRequestService = pullRequestService;
        this.refService = refService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.userService = userService;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.withRepoWrite = securityService.withPermission(Permission.REPO_WRITE, this.getClass().getSimpleName());
    }

    public void process(@Nonnull String bucketId, @Nonnull List<MergeQueueExecutorTask> tasks) {
        tasks.stream().findFirst().ifPresent(task -> {
            log.info("[{}]: Processing merge queue", (Object)task.getRepositoryId());
            this.withRepoWrite.call(() -> {
                this.process(task.getRepositoryId());
                return null;
            });
        });
    }

    private String branchFor(int repositoryId, long pullRequestId) {
        return "merge-queue/" + repositoryId + "/" + pullRequestId;
    }

    private boolean branchIsUpToDate(Branch branch, PullRequest pullRequest) {
        Commit commit = this.commitService.getCommit(new CommitRequest.Builder(pullRequest.getToRef().getRepository(), branch.getLatestCommit()).build());
        return commit.getParents().stream().map(MinimalCommit::getId).collect(Collectors.toSet()).containsAll(Set.of(pullRequest.getToRef().getLatestCommit(), pullRequest.getFromRef().getLatestCommit()));
    }

    private void cleanup(InternalMergeQueueEntry mergeQueueEntry, Repository repository, long pullRequestId) {
        this.ejectFromQueue(mergeQueueEntry);
        Branch queueBranch = this.resolveQueueBranch(repository, pullRequestId);
        if (queueBranch != null) {
            this.deleteQueueBranch(repository, queueBranch.getId());
        }
    }

    private void deleteQueueBranch(Repository repository, String queueBranchId) {
        log.debug("[{}]: Deleting temporary merge queue branch {}", (Object)repository.getId(), (Object)queueBranchId);
        this.gitCommandBuilderFactory.builder(repository).updateRef().delete(queueBranchId).build().call();
    }

    private void ejectFromQueue(InternalMergeQueueEntry mergeQueueEntry) {
        log.debug("[{}]: Ejecting pull request {} from the queue", (Object)mergeQueueEntry.getRepositoryId(), (Object)mergeQueueEntry.getPullRequestId());
        this.mergeQueueDao.delete(mergeQueueEntry);
    }

    private Optional<InternalMergeQueueEntry> peekQueueFor(int repositoryId) {
        return this.mergeQueueDao.getQueueForRepository(repositoryId, PageUtils.newRequest((int)0, (int)1)).stream().findFirst();
    }

    private PreparedPullRequestMerge prepareQueueBranch(MergeQueueEntry mergeQueueEntry, PullRequest pullRequest) {
        Branch queueBranch = this.resolveQueueBranch(pullRequest);
        if (queueBranch == null || !this.branchIsUpToDate(queueBranch, pullRequest)) {
            return this.recreateQueueBranch(mergeQueueEntry, pullRequest);
        }
        return new SimplePreparedPullRequestMerge.Builder(queueBranch, pullRequest.getToRef().getLatestCommit()).mergeMessage(mergeQueueEntry.getMessage()).mergeStrategyId(mergeQueueEntry.getStrategyId()).build();
    }

    private void process(int repositoryId) {
        this.transactionTemplate.execute(status -> {
            Repository repository = this.repositoryService.getById(repositoryId);
            if (repository == null) {
                log.warn("[{}]: Repository does not exist", (Object)repositoryId);
                return null;
            }
            MutableObject eventToPublish = new MutableObject((Object)new MergeQueueItemProcessedEvent(this, repository));
            this.peekQueueFor(repository.getId()).ifPresent(mergeQueueEntry -> {
                Duration timeSinceChecksStarted;
                PullRequestMergeability mergeability;
                Instant now = this.clock.instant();
                MergeQueueSettings settings = (MergeQueueSettings)this.securityService.withPermission(Permission.ADMIN, "read merge queue settings").call(() -> this.mergeQueueSettingsService.getInheritedOrDefault((Scope)Scopes.repository((Repository)repository)));
                Duration timeout = settings.getMergeTimeout().orElse(this.checksTimeout);
                PullRequest pullRequest = this.pullRequestService.getById(repositoryId, mergeQueueEntry.getPullRequestId());
                if (pullRequest == null) {
                    log.debug("[{}]: Pull request {} no longer exists", (Object)repositoryId, (Object)mergeQueueEntry.getPullRequestId());
                    this.cleanup((InternalMergeQueueEntry)mergeQueueEntry, repository, mergeQueueEntry.getPullRequestId());
                    this.eventPublisher.publish((Object)new MergeQueueItemEjectedEvent.Builder(repository, this).reason(this.i18nService.getMessage("bitbucket.mergequeue.pull-request.not-found", new Object[]{repositoryId, mergeQueueEntry.getPullRequestId()})).build());
                    return;
                }
                if (pullRequest.isDraft()) {
                    log.debug("[{}]: Pull request {} is in draft", (Object)repositoryId, (Object)pullRequest.getId());
                    this.cleanup((InternalMergeQueueEntry)mergeQueueEntry, repository, mergeQueueEntry.getPullRequestId());
                    this.eventPublisher.publish((Object)new MergeQueueItemEjectedEvent.Builder(repository, this).pullRequest(pullRequest).reason(this.i18nService.getMessage("bitbucket.mergequeue.pull-request.is-draft", new Object[0])).build());
                    return;
                }
                if (pullRequest.isClosed()) {
                    log.debug("[{}]: Pull request {} has a closed state {}", new Object[]{repositoryId, pullRequest.getId(), pullRequest.getState()});
                    this.cleanup((InternalMergeQueueEntry)mergeQueueEntry, repository, mergeQueueEntry.getPullRequestId());
                    this.eventPublisher.publish((Object)new MergeQueueItemEjectedEvent.Builder(repository, this).pullRequest(pullRequest).reason(this.i18nService.getMessage("bitbucket.mergequeue.pull-request.not-open", new Object[0])).build());
                    return;
                }
                ApplicationUser mergeUser = this.userService.getUserById(mergeQueueEntry.getUserId());
                if (mergeUser == null) {
                    log.warn("[{}]: Merge user {} not found for PR {}, falling back to pull request author", new Object[]{repositoryId, mergeQueueEntry.getUserId(), pullRequest.getId()});
                    mergeUser = pullRequest.getAuthor().getUser();
                }
                if ((mergeability = (PullRequestMergeability)this.securityService.impersonating(mergeUser, "do checks on behalf of merge user").call(() -> this.pullRequestService.canMerge(repositoryId, pullRequest.getId(), true))).isConflicted()) {
                    log.debug("[{}]: Skipping pull request {} because it is conflicted", (Object)repositoryId, (Object)pullRequest.getId());
                    this.cleanup((InternalMergeQueueEntry)mergeQueueEntry, repository, mergeQueueEntry.getPullRequestId());
                    this.eventPublisher.publish((Object)new MergeQueueItemEjectedEvent.Builder(repository, this).pullRequest(pullRequest).reason(this.i18nService.getMessage("bitbucket.mergequeue.pull-request.conflicted", new Object[0])).build());
                    return;
                }
                if (!mergeability.getVetoes().isEmpty()) {
                    log.debug("[{}]: Skipping pull request {} because it has merge vetoes", (Object)repositoryId, (Object)pullRequest.getId());
                    List<String> vetoDetails = mergeability.getVetoes().stream().map(RepositoryHookVeto::getSummaryMessage).toList();
                    if (log.isTraceEnabled()) {
                        log.trace("[{}]: Pull request {} vetoes {}", new Object[]{repositoryId, pullRequest.getId(), vetoDetails});
                    }
                    this.cleanup((InternalMergeQueueEntry)mergeQueueEntry, repository, mergeQueueEntry.getPullRequestId());
                    this.eventPublisher.publish((Object)new MergeQueueItemEjectedEvent.Builder(repository, this).pullRequest(pullRequest).reason(this.i18nService.getMessage("bitbucket.mergequeue.pull-request.merge-check-vetos.details", new Object[]{vetoDetails})).build());
                    return;
                }
                if (mergeQueueEntry.getMergingTime() == null) {
                    log.debug("[{}]: Pull Request {} started checks", (Object)repositoryId, (Object)pullRequest.getId());
                    this.mergeQueueDao.update(new InternalMergeQueueEntry.Builder((MergeQueueEntry)mergeQueueEntry).mergingTime(now).build());
                }
                if ((timeSinceChecksStarted = Duration.between(mergeQueueEntry.getMergingTime(), now)).compareTo(timeout) >= 0) {
                    log.info("[{}]: Pull request {} checks timed out after {}. Removing pull request from the queue.", new Object[]{repositoryId, pullRequest.getId(), timeSinceChecksStarted});
                    this.cleanup((InternalMergeQueueEntry)mergeQueueEntry, repository, mergeQueueEntry.getPullRequestId());
                    this.eventPublisher.publish((Object)new MergeQueueItemEjectedEvent.Builder(repository, this).pullRequest(pullRequest).reason(this.i18nService.getMessage("bitbucket.mergequeue.pull-request.checks-timed-out", new Object[0])).build());
                    return;
                }
                Duration timeoutAfter = timeout.minus(timeSinceChecksStarted);
                if (!DevModeUtils.isEnabled() && timeoutAfter.toMinutes() < 1L) {
                    timeoutAfter = Duration.ofMinutes(1L);
                }
                try {
                    this.securityService.impersonating(mergeUser, "merge on behalf of user making the request").call((Operation)new MergeOperation((InternalMergeQueueEntry)mergeQueueEntry, pullRequest, repository));
                }
                catch (PullRequestMergeVetoedException e) {
                    List<String> vetoDetails = e.getVetoes().stream().map(RepositoryHookVeto::getSummaryMessage).toList();
                    if (log.isTraceEnabled()) {
                        log.trace("[{}]: Pull request {} has merge vetoes {}", new Object[]{repository.getId(), pullRequest.getId(), vetoDetails});
                    } else {
                        log.debug("[{}]: Pull request {} has merge vetoes", (Object)repository.getId(), (Object)pullRequest.getId());
                    }
                    this.cleanup((InternalMergeQueueEntry)mergeQueueEntry, repository, mergeQueueEntry.getPullRequestId());
                    this.eventPublisher.publish((Object)new MergeQueueItemEjectedEvent.Builder(repository, this).pullRequest(pullRequest).reason(this.i18nService.getMessage("bitbucket.mergequeue.pull-request.merge-check-vetos.details", new Object[]{vetoDetails})).build());
                    return;
                }
                catch (RuntimeException e) {
                    this.cleanup((InternalMergeQueueEntry)mergeQueueEntry, repository, mergeQueueEntry.getPullRequestId());
                    this.eventPublisher.publish((Object)new MergeQueueItemEjectedEvent.Builder(repository, this).pullRequest(pullRequest).reason(this.i18nService.getMessage("bitbucket.mergequeue.pull-request.merge-failure", new Object[0])).build());
                    throw e;
                }
                if (pullRequest.isClosed()) {
                    log.debug("[{}]: Pull request {} closed with state {}", new Object[]{repositoryId, pullRequest.getId(), pullRequest.getState()});
                    this.cleanup((InternalMergeQueueEntry)mergeQueueEntry, repository, mergeQueueEntry.getPullRequestId());
                }
                eventToPublish.setValue((Object)new MergeQueueItemProcessedEvent(this, repository, pullRequest, pullRequest.isClosed() ? null : timeoutAfter));
            });
            this.eventPublisher.publish(eventToPublish.get());
            return null;
        });
    }

    private PreparedPullRequestMerge recreateQueueBranch(MergeQueueEntry mergeQueueEntry, PullRequest pullRequest) {
        Repository toRepository = pullRequest.getToRef().getRepository();
        String mergeQueueBranch = this.branchFor(toRepository.getId(), pullRequest.getId());
        return this.pullRequestService.prepareMerge(new PullRequestMergeRequest.Builder(pullRequest).message(mergeQueueEntry.getMessage()).autoSubject(mergeQueueEntry.isAutoSubject()).strategyId(mergeQueueEntry.getStrategyId()).build(), mergeQueueBranch);
    }

    private Branch resolveQueueBranch(PullRequest pullRequest) {
        return this.resolveQueueBranch(pullRequest.getToRef().getRepository(), pullRequest.getId());
    }

    private Branch resolveQueueBranch(Repository repository, long pullRequestId) {
        ResolveRefRequest request = new ResolveRefRequest.Builder(repository).type((RefType)StandardRefType.BRANCH).refId(this.branchFor(repository.getId(), pullRequestId)).build();
        Ref ref = this.refService.resolveRef(request);
        if (ref == null) {
            return null;
        }
        return ((SimpleBranch.Builder)((SimpleBranch.Builder)((SimpleBranch.Builder)new SimpleBranch.Builder().displayId(ref.getDisplayId())).id(ref.getId())).latestCommit(ref.getLatestCommit())).build();
    }

    private class MergeOperation
    implements Operation<Void, RuntimeException> {
        private final InternalMergeQueueEntry mergeQueueEntry;
        private final PullRequest pullRequest;
        private final Repository repository;

        public MergeOperation(InternalMergeQueueEntry mergeQueueEntry, PullRequest pullRequest, Repository repository) {
            this.mergeQueueEntry = mergeQueueEntry;
            this.pullRequest = pullRequest;
            this.repository = repository;
        }

        public Void perform() {
            return (Void)MergeQueueProcessor.this.mergeQueueEntryLock.withLock(this.pullRequest, () -> {
                PreparedPullRequestMerge preparedPullRequestMerge = MergeQueueProcessor.this.prepareQueueBranch((MergeQueueEntry)this.mergeQueueEntry, this.pullRequest);
                CombinedPreAcceptMergeResults results = MergeQueueProcessor.this.preMergeAcceptCheckHelper.runChecks(preparedPullRequestMerge, this.pullRequest);
                PreAcceptMergeCheckResult.State effectiveState = results.getEffectiveState();
                if (effectiveState == PreAcceptMergeCheckResult.State.REJECTED) {
                    log.warn("[{}]: Pull request {} REJECTED, details: {}", new Object[]{this.repository.getId(), this.pullRequest.getId(), results});
                    MergeQueueProcessor.this.cleanup(this.mergeQueueEntry, this.repository, this.mergeQueueEntry.getPullRequestId());
                    MergeQueueProcessor.this.eventPublisher.publish((Object)new MergeQueueItemEjectedEvent.Builder(this.repository, this).pullRequest(this.pullRequest).reason(MergeQueueProcessor.this.i18nService.getMessage("bitbucket.mergequeue.pull-request.checks-failed", new Object[0])).build());
                    return null;
                }
                if (effectiveState == PreAcceptMergeCheckResult.State.PENDING) {
                    log.debug("[{}]: Checks for pull request {} PENDING, detail: {}", new Object[]{this.repository.getId(), this.pullRequest.getId(), results});
                    return null;
                }
                MergeQueueProcessor.this.pullRequestService.acceptMerge(this.pullRequest, preparedPullRequestMerge);
                return null;
            });
        }
    }
}

