/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue;

import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.internal.mergequeue.dao.MergeQueueSettingsDao;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionProcessor;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessingRequest;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class MergeQueueSettingsRestrictionProcessor
implements ProjectSettingsRestrictionProcessor {
    private static final Logger log = LoggerFactory.getLogger(MergeQueueSettingsRestrictionProcessor.class);
    private final MergeQueueSettingsDao mergeQueueSettingsDao;

    public MergeQueueSettingsRestrictionProcessor(MergeQueueSettingsDao mergeQueueSettingsDao) {
        this.mergeQueueSettingsDao = mergeQueueSettingsDao;
    }

    @Nonnull
    public String getFeatureKey() {
        return ProjectSettingsRestrictionKeys.MERGE_QUEUE.getFeatureKey();
    }

    @Nonnull
    public String getNamespace() {
        return ProjectSettingsRestrictionKeys.MERGE_QUEUE.getNamespace();
    }

    @Transactional
    public boolean process(@Nonnull RestrictionProcessingRequest processingRequest) {
        Objects.requireNonNull(processingRequest, "processingRequest");
        log.trace("Deleting merge queue settings for request {}", (Object)processingRequest);
        if (processingRequest.getRepositories().isEmpty()) {
            log.trace("No repos to process for request {}", (Object)processingRequest);
            return true;
        }
        Set repositoryIds = (Set)processingRequest.getRepositories().stream().map(Repository::getId).collect(ImmutableSet.toImmutableSet());
        try (Ticker ignored = Timers.timer((String)("MergeQueueSettingsRestrictionProcessor: Processing restrictions for " + repositoryIds.size() + " repositories")).start(new String[0]);){
            try {
                int totalSettingsDeleted = this.mergeQueueSettingsDao.deleteByRepositoryIds(repositoryIds);
                log.trace("Successfully deleted {} merge queue settings for request {}", (Object)totalSettingsDeleted, (Object)processingRequest);
            }
            catch (Exception e) {
                log.error("Error while deleting merge queue settings for request {}", (Object)processingRequest, (Object)e);
                boolean bl = false;
                if (ignored != null) {
                    ignored.close();
                }
                return bl;
            }
        }
        return true;
    }
}

