/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue;

import com.atlassian.bitbucket.dmz.pull.PreAcceptMergeCheck;
import com.atlassian.bitbucket.dmz.pull.PreAcceptMergeCheckModuleDescriptor;
import com.atlassian.bitbucket.dmz.pull.PreAcceptMergeCheckRequest;
import com.atlassian.bitbucket.dmz.pull.PreAcceptMergeCheckResult;
import com.atlassian.bitbucket.dmz.pull.PreAcceptMergeCheckSupplierModuleDescriptor;
import com.atlassian.bitbucket.dmz.pull.PreparedPullRequestMerge;
import com.atlassian.bitbucket.dmz.pull.SimplePreAcceptMergeCheckRequest;
import com.atlassian.bitbucket.internal.mergequeue.CombinedPreAcceptMergeResults;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Streams;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class PreMergeAcceptCheckHelper {
    private final PluginAccessor pluginAccessor;

    public PreMergeAcceptCheckHelper(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public CombinedPreAcceptMergeResults runChecks(@Nonnull PreparedPullRequestMerge preparedPullRequestMerge, @Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(preparedPullRequestMerge, "preparedPullRequestMerge");
        Objects.requireNonNull(pullRequest, "pullRequest");
        SimplePreAcceptMergeCheckRequest preAcceptMergeCheckRequest = new SimplePreAcceptMergeCheckRequest(preparedPullRequestMerge, pullRequest);
        return new CombinedPreAcceptMergeResults(this.getRegisteredChecks().stream().map(arg_0 -> PreMergeAcceptCheckHelper.lambda$runChecks$0((PreAcceptMergeCheckRequest)preAcceptMergeCheckRequest, arg_0)).toList());
    }

    private List<PreAcceptMergeCheck> getRegisteredChecks() {
        Stream dynamicMergeChecks = ModuleDescriptorUtils.toModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(PreAcceptMergeCheckSupplierModuleDescriptor.class)).flatMap(supplier -> supplier.getPreAcceptMergeChecks().stream());
        Stream staticMergeChecks = ModuleDescriptorUtils.toModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(PreAcceptMergeCheckModuleDescriptor.class));
        return Streams.concat((Stream[])new Stream[]{dynamicMergeChecks, staticMergeChecks}).toList();
    }

    private static /* synthetic */ PreAcceptMergeCheckResult lambda$runChecks$0(PreAcceptMergeCheckRequest preAcceptMergeCheckRequest, PreAcceptMergeCheck preAcceptMergeCheck) {
        return preAcceptMergeCheck.run(preAcceptMergeCheckRequest);
    }
}

