/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.event.pull.DmzPullRequestMergedEvent;
import com.atlassian.bitbucket.internal.mergequeue.event.MergeQueueItemAddedEvent;
import com.atlassian.bitbucket.internal.mergequeue.event.MergeQueueItemEjectedEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;

public class MergeQueueAuditingEventListener {
    private static final String ACTION_QUEUE_ITEM_ADDED = "bitbucket.mergequeue.audit.action.queueitem.added";
    private static final String ACTION_QUEUE_ITEM_EJECTED = "bitbucket.mergequeue.audit.action.queueitem.ejected";
    private static final String ACTION_QUEUE_ITEM_MERGED = "bitbucket.mergequeue.audit.action.queueitem.merged";
    private static final String ATTR_EJECTED_REASON = "bitbucket.mergequeue.audit.attribute.ejectedreason";
    private final AuditService auditService;

    public MergeQueueAuditingEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onMergeQueueItemAdded(MergeQueueItemAddedEvent event) {
        this.auditService.audit(this.getBuilder(ACTION_QUEUE_ITEM_ADDED).affectedObjects(AuditUtils.auditResourcesForProjectRepositoryPullRequest((PullRequest)event.getPullRequest())).build());
    }

    @EventListener
    public void onMergeQueueItemEjected(MergeQueueItemEjectedEvent event) {
        AuditEvent.Builder auditEvent = this.getBuilder(ACTION_QUEUE_ITEM_EJECTED);
        if (event.getPullRequest() == null) {
            auditEvent.affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)event.getRepository()));
        } else {
            auditEvent.affectedObjects(AuditUtils.auditResourcesForProjectRepositoryPullRequest((PullRequest)event.getPullRequest()));
        }
        if (event.getReason() != null) {
            auditEvent.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_EJECTED_REASON, (String)event.getReason()).build());
        }
        this.auditService.audit(auditEvent.build());
    }

    @EventListener
    public void onPullRequestMergedEvent(DmzPullRequestMergedEvent event) {
        if (event.isQueuedMerge()) {
            this.auditService.audit(this.getBuilder(ACTION_QUEUE_ITEM_MERGED).affectedObjects(AuditUtils.auditResourcesForProjectRepositoryPullRequest((PullRequest)event.getPullRequest())).build());
        }
    }

    private AuditEvent.Builder getBuilder(String action) {
        return AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.pullrequests", (String)action).build());
    }
}

