/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue.cleanup;

import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeQueueBranch {
    private static final Logger log = LoggerFactory.getLogger(MergeQueueBranch.class);
    private final String branchId;
    private final long pullRequestId;
    private final int repositoryId;

    private MergeQueueBranch(@Nonnull String branchId, int repositoryId, long pullRequestId) {
        this.branchId = Objects.requireNonNull(branchId, "branchId");
        this.repositoryId = repositoryId;
        this.pullRequestId = pullRequestId;
    }

    public static Optional<MergeQueueBranch> fromBranchId(@Nonnull String branchId) {
        Objects.requireNonNull(branchId, "branchId");
        if (!branchId.startsWith("refs/heads/merge-queue/")) {
            log.trace("{} is not a valid merge queue branch", (Object)branchId);
            return Optional.empty();
        }
        String suffix = branchId.substring("refs/heads/merge-queue/".length());
        String[] parts = suffix.split("/");
        if (parts.length != 2) {
            log.trace("{} is not a valid merge queue branch", (Object)branchId);
            return Optional.empty();
        }
        try {
            int repositoryId = Integer.parseInt(parts[0]);
            long pullRequestId = Long.parseLong(parts[1]);
            return Optional.of(new MergeQueueBranch(branchId, repositoryId, pullRequestId));
        }
        catch (NumberFormatException e) {
            log.trace("{} is not a valid merge queue branch", (Object)branchId, (Object)e);
            return Optional.empty();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeQueueBranch that = (MergeQueueBranch)o;
        return this.pullRequestId == that.pullRequestId && this.repositoryId == that.repositoryId && Objects.equals(this.branchId, that.branchId);
    }

    public String getBranchId() {
        return this.branchId;
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public int hashCode() {
        return Objects.hash(this.branchId, this.pullRequestId, this.repositoryId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("branchId", (Object)this.branchId).add("pullRequestId", this.pullRequestId).add("repositoryId", this.repositoryId).toString();
    }
}

