/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue.cleanup;

import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettingsService;
import com.atlassian.bitbucket.internal.mergequeue.cleanup.MergeQueueBranch;
import com.atlassian.bitbucket.internal.mergequeue.cleanup.StaleMergeQueueBranchHandler;
import com.atlassian.bitbucket.internal.mergequeue.event.MergeQueueItemProcessedEvent;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.BranchCallback;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.BranchesCommandParameters;
import com.atlassian.bitbucket.scm.git.command.GitCommandFactory;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.random.RandomGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaleMergeQueueBranchCleanupTask {
    private static final Logger log = LoggerFactory.getLogger(StaleMergeQueueBranchCleanupTask.class);
    private final StaleMergeQueueBranchHandler branchHandler;
    private final double chance;
    private final ExecutorService executorService;
    private final GitCommandFactory gitCommandFactory;
    private final RandomGenerator randomGenerator;

    public StaleMergeQueueBranchCleanupTask(StaleMergeQueueBranchHandler branchHandler, ExecutorService executorService, GitCommandFactory gitCommandFactory, MergeQueueSettingsService mergeQueueSettingsService) {
        this(branchHandler, executorService, gitCommandFactory, mergeQueueSettingsService, new Random());
    }

    @VisibleForTesting
    StaleMergeQueueBranchCleanupTask(StaleMergeQueueBranchHandler branchHandler, ExecutorService executorService, GitCommandFactory gitCommandFactory, MergeQueueSettingsService mergeQueueSettingsService, RandomGenerator randomGenerator) {
        this.branchHandler = branchHandler;
        this.executorService = executorService;
        this.gitCommandFactory = gitCommandFactory;
        this.randomGenerator = randomGenerator;
        this.chance = mergeQueueSettingsService.getStaleBranchCleanupChance();
    }

    @EventListener
    public void onMergeQueueItemProcessedEvent(MergeQueueItemProcessedEvent event) {
        this.maybeScheduleCleanup(event.getRepository());
    }

    @VisibleForTesting
    void maybeScheduleCleanup(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        if (!this.shouldRun()) {
            log.debug("Stale merge queue branch cleanup not scheduled this time");
            return;
        }
        log.debug("Scheduling stale merge queue branch cleanup");
        this.executorService.submit(() -> this.performCleanup(repository));
        log.debug("Stale merge queue branch cleanup scheduled");
    }

    private void performCleanup(Repository repository) {
        log.debug("Running merge queue branch cleanup task");
        this.gitCommandFactory.branches(repository, ((BranchesCommandParameters.Builder)new BranchesCommandParameters.Builder().filterText("merge-queue/")).build(), (BranchCallback)new CleanupTaskBranchCallback(repository)).call();
        log.debug("Finished running merge queue branch cleanup");
    }

    private boolean shouldRun() {
        if (this.chance == 0.0) {
            log.trace("Stale merge queue branch cleanup will not run because chance is set to 0");
            return false;
        }
        if (this.chance == 1.0) {
            log.trace("Stale merge queue branch cleanup will run because chance is set to 1");
            return true;
        }
        double randomNumber = this.randomGenerator.nextDouble(1.0);
        boolean shouldRun = randomNumber <= this.chance;
        log.trace("Stale merge queue branch cleanup decision: {} based on chance value: {}", (Object)shouldRun, (Object)this.chance);
        return shouldRun;
    }

    @VisibleForTesting
    class CleanupTaskBranchCallback
    implements BranchCallback {
        private final Repository repository;

        public CleanupTaskBranchCallback(Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        public boolean onBranch(@Nonnull Branch branch) {
            try {
                MergeQueueBranch.fromBranchId(branch.getId()).ifPresent(mergeQueueBranch -> StaleMergeQueueBranchCleanupTask.this.branchHandler.deleteIfStale(this.repository, (MergeQueueBranch)mergeQueueBranch));
            }
            catch (Exception e) {
                log.warn("Failed to cleanup merge queue branch", (Throwable)e);
            }
            return true;
        }
    }
}

