/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue.cleanup;

import com.atlassian.bitbucket.internal.mergequeue.cleanup.MergeQueueBranch;
import com.atlassian.bitbucket.internal.mergequeue.concurrent.MergeQueueEntryLock;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaleMergeQueueBranchHandler {
    private static final Logger log = LoggerFactory.getLogger(StaleMergeQueueBranchHandler.class);
    private final GitCommandBuilderFactory gitCommandBuilderFactory;
    private final MergeQueueEntryLock mergeQueueEntryLock;
    private final PullRequestService pullRequestService;

    public StaleMergeQueueBranchHandler(GitCommandBuilderFactory gitCommandBuilderFactory, MergeQueueEntryLock mergeQueueEntryLock, PullRequestService pullRequestService) {
        this.gitCommandBuilderFactory = gitCommandBuilderFactory;
        this.mergeQueueEntryLock = mergeQueueEntryLock;
        this.pullRequestService = pullRequestService;
    }

    public void deleteIfStale(@Nonnull Repository repository, @Nonnull MergeQueueBranch mergeQueueBranch) {
        Objects.requireNonNull(mergeQueueBranch, "mergeQueueBranch");
        int repositoryId = mergeQueueBranch.getRepositoryId();
        long pullRequestId = mergeQueueBranch.getPullRequestId();
        PullRequest pullRequest = this.pullRequestService.getById(repositoryId, pullRequestId);
        if (pullRequest == null) {
            log.debug("Pull request {}/{} does not exist, merge queue branch is stale", (Object)repositoryId, (Object)pullRequestId);
            this.deleteBranch(repository, mergeQueueBranch.getBranchId());
            return;
        }
        this.mergeQueueEntryLock.withLock(pullRequest, () -> {
            if (!pullRequest.isOpen()) {
                log.debug("Pull request {}/{} is not open, merge queue branch is stale", (Object)repositoryId, (Object)pullRequestId);
                this.deleteBranch(repository, mergeQueueBranch.getBranchId());
                return null;
            }
            return null;
        });
    }

    private void deleteBranch(Repository repository, String branchId) {
        this.gitCommandBuilderFactory.builder(repository).updateRef().delete(branchId).build().call();
        log.debug("Branch {} for repository {} successfully deleted", (Object)branchId, (Object)repository.getId());
    }
}

