/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue.dao;

import com.atlassian.bitbucket.dmz.mergequeue.QueuedPullRequestSearchRequest;
import com.atlassian.bitbucket.internal.mergequeue.dao.MergeQueueDao;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.mergequeue.InternalMergeQueueEntry;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="mergeQueueDao")
public class HibernateMergeQueueDao
extends AbstractHibernateDao<Long, InternalMergeQueueEntry>
implements MergeQueueDao {
    @Autowired
    public HibernateMergeQueueDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public InternalMergeQueueEntry create(InternalMergeQueueEntry entity) {
        this.session().save((Object)entity);
        return (InternalMergeQueueEntry)HibernateUtils.initialize((Object)entity);
    }

    @Override
    public int deleteByRepositoryScopedId(int repositoryId, long pullRequestId) {
        String hql = "delete from InternalMergeQueueEntry where pullRequestId = :pullRequestId and repositoryId = :repositoryId";
        return this.session().createQuery(hql).setParameter("pullRequestId", (Object)pullRequestId, (Type)StandardBasicTypes.LONG).setParameter("repositoryId", (Object)repositoryId, (Type)StandardBasicTypes.INTEGER).executeUpdate();
    }

    @Override
    @Nonnull
    public Page<InternalMergeQueueEntry> getQueueForRepository(int repositoryId, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        String hql = "from InternalMergeQueueEntry where repositoryId = :repositoryId order by ordinalId asc, pullRequestId asc";
        Query query = this.session().createQuery(hql).setParameter("repositoryId", (Object)repositoryId, (Type)StandardBasicTypes.INTEGER);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    @Override
    @Nonnull
    public Map<Long, Boolean> isQueuedByPullRequest(@Nonnull Set<Long> pullRequestIds) {
        Objects.requireNonNull(pullRequestIds, "pullRequestIds");
        if (pullRequestIds.isEmpty()) {
            return Map.of();
        }
        Set list = HqlQueryBuilder.selectPropertiesFrom(InternalMergeQueueEntry.class, (HqlQueryBuilder.HqlSelectProperty[])new HqlQueryBuilder.HqlSelectProperty[]{HqlQueryBuilder.property((String)"pullRequestId")}).where(HqlQueryBuilder.HqlWhereQueryComponent.in((String)"pullRequestId", pullRequestIds)).buildQuery(this.session(), Long.class).stream().collect(Collectors.toUnmodifiableSet());
        return pullRequestIds.stream().collect(Collectors.toMap(Function.identity(), list::contains));
    }

    @Override
    @Nonnull
    public Page<InternalPullRequest> searchQueuedPullRequests(@Nonnull QueuedPullRequestSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        Object hql = "select pr from InternalPullRequest pr inner join InternalMergeQueueEntry mqe on pr.toRef.repository.id = mqe.repositoryId and pr.scopedId = mqe.pullRequestId where mqe.repositoryId = :repositoryId";
        if (!request.getToRefIds().isEmpty()) {
            hql = (String)hql + " and pr.toRef.id in (:toRefIds)";
        }
        hql = (String)hql + " order by mqe.ordinalId asc, mqe.pullRequestId asc";
        Query query = this.session().createQuery((String)hql, InternalPullRequest.class).setParameter("repositoryId", (Object)request.getToRepositoryId(), (Type)StandardBasicTypes.INTEGER);
        if (!request.getToRefIds().isEmpty()) {
            query.setParameter("toRefIds", HibernateMergeQueueDao.qualifyRefIds(request.getToRefIds()));
        }
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    private static Set<String> qualifyRefIds(Set<String> refIds) {
        return refIds.stream().map(arg_0 -> ((GitRefPattern)GitRefPattern.HEADS).qualify(arg_0)).collect(Collectors.toUnmodifiableSet());
    }
}

