/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue.dao;

import com.atlassian.bitbucket.internal.mergequeue.dao.MergeQueueSettingsDao;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.mergequeue.InternalMergeQueueSettings;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scope.Scopeable;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.springframework.stereotype.Repository;

@Repository(value="mergeQueueSettingsDao")
public class HibernateMergeQueueSettingsDao
extends AbstractHibernateDao<Long, InternalMergeQueueSettings>
implements MergeQueueSettingsDao {
    private static final int BULK_DELETE_MAX_SIZE = 1000;

    public HibernateMergeQueueSettingsDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public int deleteByRepositoryIds(Set<Integer> repositoryIds) {
        Objects.requireNonNull(repositoryIds, "repositoryIds");
        if (repositoryIds.isEmpty()) {
            return 0;
        }
        if (repositoryIds.size() > 1000) {
            throw new IllegalArgumentException("Repository IDs cannot exceed 1000 entries");
        }
        String hql = "DELETE FROM InternalMergeQueueSettings WHERE scope.class = :scopeType AND scope.id in (:scopeIds)";
        return this.session().createQuery(hql).setParameter("scopeType", (Object)InternalRepository.class.getName()).setParameter("scopeIds", repositoryIds).executeUpdate();
    }

    @Override
    @Nullable
    public InternalMergeQueueSettings findByScope(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        if (scope.getType() == ScopeType.GLOBAL) {
            return null;
        }
        String hql = "FROM InternalMergeQueueSettings WHERE scope = :scope";
        return (InternalMergeQueueSettings)HibernateUtils.initialize((Object)((InternalMergeQueueSettings)this.session().createQuery(hql, InternalMergeQueueSettings.class).setParameter("scope", (Object)Scopeable.fromScope((Scope)scope)).uniqueResult()));
    }

    @Override
    @Nullable
    public InternalMergeQueueSettings findInheritedSettings(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        if (scope.getType() == ScopeType.GLOBAL) {
            return null;
        }
        Set<Scopeable> scopeables = HibernateMergeQueueSettingsDao.getInheritedScopeables(scope);
        String hql = "FROM InternalMergeQueueSettings WHERE scope IN :scopes order by scope_type desc";
        return (InternalMergeQueueSettings)HibernateUtils.initialize((Object)((InternalMergeQueueSettings)this.session().createQuery(hql, InternalMergeQueueSettings.class).setCacheable(true).setCacheRegion("query.mergeQueueSettingsByScope").setParameterList("scopes", scopeables).setMaxResults(1).uniqueResult()));
    }

    private static Set<Scopeable> getInheritedScopeables(Scope scope) {
        return (Set)scope.accept((ScopeVisitor)new ScopeVisitor<Set<Scopeable>>(){

            public Set<Scopeable> visit(@Nonnull ProjectScope scope) {
                return ImmutableSet.of((Object)Scopeable.fromScope((Scope)scope));
            }

            public Set<Scopeable> visit(@Nonnull RepositoryScope scope) {
                return ImmutableSet.of((Object)Scopeable.fromScope((Scope)scope), (Object)Scopeable.fromScope((Scope)Scopes.project((Project)scope.getProject())));
            }
        });
    }
}

