/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue.event;

import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetEvent;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueService;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mergequeue.event.MergeQueueItemEjectedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;

public class MergeQueueEventListener {
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final MergeQueueService mergeQueueService;
    private final EscalatedSecurityContext withRepoAdmin;

    public MergeQueueEventListener(EventPublisher eventPublisher, I18nService i18nService, MergeQueueService mergeQueueService, SecurityService securityService) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.mergeQueueService = mergeQueueService;
        this.withRepoAdmin = securityService.withPermission(Permission.REPO_ADMIN, "Merge queue events");
    }

    @EventListener
    public void onPullRequestRescopedEvent(PullRequestRescopedEvent event) {
        PullRequest pullRequest = event.getPullRequest();
        if (this.mergeQueueService.isQueued(pullRequest)) {
            this.triggerChecks(pullRequest.getToRef().getRepository());
        }
    }

    @EventListener
    public void onPullRequestUpdatedEvent(PullRequestUpdatedEvent event) {
        PullRequest pullRequest = event.getPullRequest();
        if (pullRequest.isDraft()) {
            Repository repository = event.getPullRequest().getToRef().getRepository();
            this.withRepoAdmin.call(() -> this.mergeQueueService.removeFromQueue(pullRequest));
            this.eventPublisher.publish((Object)new MergeQueueItemEjectedEvent.Builder(repository, this).pullRequest(pullRequest).reason(this.i18nService.getMessage("bitbucket.mergequeue.pull-request.is-draft", new Object[]{repository.getId(), pullRequest.getId()})).build());
        }
    }

    @EventListener
    public void onRepositoryBuildStatusSetEvent(RepositoryBuildStatusSetEvent event) {
        this.triggerChecks(event.getBuildStatus().getRepository());
    }

    private void triggerChecks(Repository repository) {
        this.withRepoAdmin.call(() -> {
            this.mergeQueueService.triggerChecks(repository);
            return null;
        });
    }
}

