/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue.event;

import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

@TransactionAware
public class MergeQueueItemEjectedEvent
extends RepositoryEvent {
    private final PullRequest pullRequest;
    private final String reason;

    private MergeQueueItemEjectedEvent(Builder builder) {
        super(builder.source, builder.repository);
        this.pullRequest = builder.pullRequest;
        this.reason = builder.reason;
    }

    @Nullable
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public static class Builder {
        private final Repository repository;
        private final Object source;
        private PullRequest pullRequest;
        private String reason;

        public Builder(@Nonnull Repository repository, @Nonnull Object source) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.source = Objects.requireNonNull(source, "source");
        }

        public MergeQueueItemEjectedEvent build() {
            return new MergeQueueItemEjectedEvent(this);
        }

        @Nonnull
        public Builder pullRequest(@Nullable PullRequest value) {
            this.pullRequest = value;
            return this;
        }

        @Nonnull
        public Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }
    }
}

