/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue.event;

import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@AsynchronousPreferred
@TransactionAware
public class MergeQueueItemProcessedEvent
extends RepositoryEvent {
    private final PullRequest pullRequest;
    private final Duration timeoutAfter;

    public MergeQueueItemProcessedEvent(@Nonnull Object source, @Nonnull Repository repository) {
        super(source, repository);
        this.pullRequest = null;
        this.timeoutAfter = null;
    }

    public MergeQueueItemProcessedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull PullRequest pullRequest, @Nullable Duration timeoutAfter) {
        super(source, repository);
        this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        this.timeoutAfter = timeoutAfter;
    }

    public Optional<PullRequest> getPullRequest() {
        return Optional.ofNullable(this.pullRequest);
    }

    public Optional<Duration> getTimeoutAfter() {
        return Optional.ofNullable(this.timeoutAfter);
    }
}

