/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue.hook;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.dmz.hook.DmzRepositoryHookTrigger;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeSet;

public class MergeQueueRefGuardHook
implements PreRepositoryHook<RepositoryHookRequest> {
    private final DarkFeatureManager darkFeatureManager;
    private final I18nService i18nService;

    public MergeQueueRefGuardHook(DarkFeatureManager darkFeatureManager, I18nService i18nService) {
        this.darkFeatureManager = darkFeatureManager;
        this.i18nService = i18nService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull RepositoryHookRequest request) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(request, "request");
        if (!this.darkFeatureManager.isEnabledForAllUsers("merge.queue").orElse(false).booleanValue()) {
            return RepositoryHookResult.accepted();
        }
        if (request.getTrigger() == DmzRepositoryHookTrigger.MERGE_QUEUE) {
            return RepositoryHookResult.accepted();
        }
        TreeSet rejected = Sets.newTreeSet();
        for (RefChange refChange : request.getRefChanges()) {
            String refId = refChange.getRef().getId();
            if (!refId.toLowerCase(Locale.ROOT).startsWith("refs/heads/merge-queue/")) continue;
            rejected.add(refId);
        }
        if (rejected.isEmpty()) {
            return RepositoryHookResult.accepted();
        }
        String summary = this.i18nService.getMessage("bitbucket.mergequeue.refreserved", new Object[]{Product.NAME});
        StringBuilder details = new StringBuilder("Rejected refs:\n");
        for (String ref : rejected) {
            details.append("\t").append(ref).append("\n");
        }
        return RepositoryHookResult.rejected((String)summary, (String)details.toString());
    }
}

