/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue.property;

import com.atlassian.bitbucket.internal.mergequeue.dao.MergeQueueDao;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestPropertyContext;
import com.atlassian.bitbucket.pull.PullRequestPropertyProvider;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MergeQueuePullRequestPropertyProvider
implements PullRequestPropertyProvider {
    private static final String IS_QUEUED_PROPERTY = "isQueued";
    private final DarkFeatureManager darkFeatureManager;
    private final MergeQueueDao mergeQueueDao;

    public MergeQueuePullRequestPropertyProvider(DarkFeatureManager darkFeatureManager, MergeQueueDao mergeQueueDao) {
        this.darkFeatureManager = darkFeatureManager;
        this.mergeQueueDao = mergeQueueDao;
    }

    public void provideProperties(@Nonnull PullRequestPropertyContext context) {
        if (!this.darkFeatureManager.isEnabledForAllUsers("merge.queue").orElse(false).booleanValue()) {
            return;
        }
        Map pullRequests = MoreStreams.streamIterable((Iterable)context).map(InternalConverter::convertToInternalPullRequest).collect(Collectors.toMap(InternalPullRequest::getGlobalId, Function.identity()));
        this.mergeQueueDao.isQueuedByPullRequest(pullRequests.keySet()).forEach((pullRequestId, isQueued) -> context.setProperty((PullRequest)pullRequests.get(pullRequestId), IS_QUEUED_PROPERTY, isQueued));
    }
}

