/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mergequeue;

import com.atlassian.audit.api.AuditService;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueService;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettingsService;
import com.atlassian.bitbucket.dmz.mergequeue.PullRequestMergeService;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mergequeue.DefaultMergeQueueService;
import com.atlassian.bitbucket.internal.mergequeue.DefaultMergeQueueSettingsService;
import com.atlassian.bitbucket.internal.mergequeue.DefaultPullRequestMergeService;
import com.atlassian.bitbucket.internal.mergequeue.MergeQueueProcessor;
import com.atlassian.bitbucket.internal.mergequeue.MergeQueueSettingsRestrictionProcessor;
import com.atlassian.bitbucket.internal.mergequeue.PreMergeAcceptCheckHelper;
import com.atlassian.bitbucket.internal.mergequeue.audit.MergeQueueAuditingEventListener;
import com.atlassian.bitbucket.internal.mergequeue.cleanup.StaleMergeQueueBranchCleanupTask;
import com.atlassian.bitbucket.internal.mergequeue.cleanup.StaleMergeQueueBranchHandler;
import com.atlassian.bitbucket.internal.mergequeue.concurrent.MergeQueueEntryLock;
import com.atlassian.bitbucket.internal.mergequeue.dao.HibernateMergeQueueDao;
import com.atlassian.bitbucket.internal.mergequeue.dao.HibernateMergeQueueSettingsDao;
import com.atlassian.bitbucket.internal.mergequeue.dao.MergeQueueDao;
import com.atlassian.bitbucket.internal.mergequeue.dao.MergeQueueSettingsDao;
import com.atlassian.bitbucket.internal.mergequeue.event.MergeQueueEventListener;
import com.atlassian.bitbucket.internal.mergequeue.mirror.MirrorMergeQueueService;
import com.atlassian.bitbucket.internal.mergequeue.mirror.MirrorMergeQueueSettingsService;
import com.atlassian.bitbucket.internal.mergequeue.mirror.MirrorPullRequestMergeService;
import com.atlassian.bitbucket.internal.mergequeue.property.MergeQueuePullRequestPropertyProvider;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitCommandFactory;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.mode.MirrorApplicationMode;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class MergeQueueWiring {

    @MirrorApplicationMode
    public static class MirrorApplicationModeWiring {
        @AvailableToPlugins(value=MergeQueueService.class)
        @Bean
        MergeQueueService mergeQueueService() {
            return new MirrorMergeQueueService();
        }

        @AvailableToPlugins(value=MergeQueueSettingsService.class)
        @Bean
        MergeQueueSettingsService mergeQueueSettingsService() {
            return new MirrorMergeQueueSettingsService();
        }

        @AvailableToPlugins(value=PullRequestMergeService.class)
        @Bean
        PullRequestMergeService pullRequestMergeService() {
            return new MirrorPullRequestMergeService();
        }
    }

    @DefaultApplicationMode
    public static class ApplicationModeWiring {
        @Bean
        MergeQueueAuditingEventListener mergeQueueAuditingEventListener(AuditService auditService) {
            return new MergeQueueAuditingEventListener(auditService);
        }

        @Bean
        StaleMergeQueueBranchHandler mergeQueueBranchStalenessChecker(GitCommandBuilderFactory gitCommandBuilderFactory, MergeQueueEntryLock mergeQueueEntryLock, PullRequestService pullRequestService) {
            return new StaleMergeQueueBranchHandler(gitCommandBuilderFactory, mergeQueueEntryLock, pullRequestService);
        }

        @Bean
        MergeQueueDao mergeQueueDao(SessionFactory sessionFactory) {
            return new HibernateMergeQueueDao(sessionFactory);
        }

        @Bean
        MergeQueueEntryLock mergeQueueEntryLock(LockService lockService) {
            return new MergeQueueEntryLock(lockService);
        }

        @Bean
        MergeQueueEventListener mergeQueueEventListener(EventPublisher eventPublisher, I18nService i18nService, MergeQueueService mergeQueueService, SecurityService securityService) {
            return new MergeQueueEventListener(eventPublisher, i18nService, mergeQueueService, securityService);
        }

        @Bean
        MergeQueueProcessor mergeQueueProcessor(@Value(value="${mergequeue.checks.timeout}") long checksTimeoutMinutes, CommitService commitService, EventPublisher eventPublisher, GitCommandBuilderFactory gitCommandBuilderFactory, I18nService i18nService, MergeQueueDao mergeQueueDao, MergeQueueEntryLock mergeQueueEntryLock, MergeQueueSettingsService mergeQueueSettingsService, PreMergeAcceptCheckHelper preMergeAcceptCheckHelper, DmzPullRequestService pullRequestService, RefService refService, RepositoryService repositoryService, SecurityService securityService, PlatformTransactionManager transactionManager, UserService userService) {
            return new MergeQueueProcessor(Duration.ofMinutes(checksTimeoutMinutes), commitService, eventPublisher, gitCommandBuilderFactory, i18nService, mergeQueueDao, mergeQueueEntryLock, mergeQueueSettingsService, preMergeAcceptCheckHelper, pullRequestService, refService, repositoryService, securityService, transactionManager, userService);
        }

        @Bean
        MergeQueuePullRequestPropertyProvider mergeQueuePullRequestPropertyProvider(DarkFeatureManager darkFeatureManager, MergeQueueDao mergeQueueDao) {
            return new MergeQueuePullRequestPropertyProvider(darkFeatureManager, mergeQueueDao);
        }

        @AvailableToPlugins(value=MergeQueueService.class)
        @Bean
        MergeQueueService mergeQueueService(AuthenticationContext authenticationContext, ConcurrencyService concurrencyService, EventPublisher eventPublisher, I18nService i18nService, MergeQueueDao mergeQueueDao, MergeQueueEntryLock mergeQueueEntryLock, MergeQueueProcessor mergeQueueProcessor, MergeQueueSettingsService mergeQueueSettingsService, DmzPullRequestService pullRequestService, TransactionSynchronizer transactionSynchronizer) {
            return new DefaultMergeQueueService(authenticationContext, concurrencyService, eventPublisher, i18nService, mergeQueueDao, mergeQueueEntryLock, mergeQueueProcessor, mergeQueueSettingsService, pullRequestService, transactionSynchronizer);
        }

        @Bean
        MergeQueueSettingsDao mergeQueueSettingsDao(SessionFactory sessionFactory) {
            return new HibernateMergeQueueSettingsDao(sessionFactory);
        }

        @Bean
        MergeQueueSettingsRestrictionProcessor mergeQueueSettingsRestrictionProcessor(MergeQueueSettingsDao mergeQueueSettingsDao) {
            return new MergeQueueSettingsRestrictionProcessor(mergeQueueSettingsDao);
        }

        @AvailableToPlugins(value=MergeQueueSettingsService.class)
        @Bean
        MergeQueueSettingsService mergeQueueSettingsService(InternalApplicationPropertiesService applicationPropertiesService, DarkFeatureManager darkFeatureManager, I18nService i18nService, MergeQueueSettingsDao mergeQueueSettingsDao, @Value(value="${mergequeue.checks.timeout}") long mergeTimeoutMinutes, PermissionValidationService permissionValidationService, ProjectSettingsRestrictionService projectSettingsRestrictionService, PullRequestService pullRequestService, RefService refService) {
            return new DefaultMergeQueueSettingsService(applicationPropertiesService, darkFeatureManager, Duration.ofMinutes(mergeTimeoutMinutes), mergeQueueSettingsDao, i18nService, permissionValidationService, projectSettingsRestrictionService, pullRequestService, refService);
        }

        @Bean
        PreMergeAcceptCheckHelper preMergeAcceptCheckHelper(PluginAccessor pluginAccessor) {
            return new PreMergeAcceptCheckHelper(pluginAccessor);
        }

        @AvailableToPlugins(value=PullRequestMergeService.class)
        @Bean
        PullRequestMergeService pullRequestMergeService(MergeQueueService mergeQueueService, MergeQueueSettingsService mergeQueueSettingsService, InternalPullRequestService pullRequestService) {
            return new DefaultPullRequestMergeService(mergeQueueService, mergeQueueSettingsService, pullRequestService);
        }

        @Bean
        StaleMergeQueueBranchCleanupTask staleMergeQueueBranchCleanupTask(StaleMergeQueueBranchHandler branchHandler, ExecutorService executorService, GitCommandFactory gitCommandFactory, MergeQueueSettingsService mergeQueueSettingsService) {
            return new StaleMergeQueueBranchCleanupTask(branchHandler, executorService, gitCommandFactory, mergeQueueSettingsService);
        }
    }
}

