/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.home.DefaultHomeSubdirectoryResolver;
import com.atlassian.stash.internal.home.HomeDirectoryDetails;
import com.atlassian.stash.internal.home.HomeSubdirectoryResolver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeLayout {
    public static final String LOG_PATH = "log";
    public static final String CONFIG_DIR_NAME = "config";
    public static final String DATA_DIR_NAME = "data";
    public static final String PLUGINS_DIR_NAME = "plugins";
    public static final String INSTALLED_PLUGINS_DIR_NAME = "installed-plugins";
    public static final String REPOSITORIES_DIR_NAME = "repositories";
    public static final Version VERSION = new Version(new Integer[]{12});
    private static final Logger log = LoggerFactory.getLogger(HomeLayout.class);
    private final Path attachmentsDir;
    private final Path binDir;
    private final Path bundledPluginsDir;
    private final Path cacheDir;
    private final Path configDir;
    private final Path dataDir;
    private final Path exportDir;
    private final Path hierarchiesDir;
    private final Path homeDir;
    private final Path installedPluginsDir;
    private final Path libDir;
    private final Path logDir;
    private final Path nativeDir;
    private final Path pluginsDir;
    private final Path osgiCacheDir;
    private final Path reposDir;
    private final Path sharedHomeDir;
    private final Path sharedPluginsDir;
    private final Path tempDir;
    private final Path upgradesDir;

    public HomeLayout(HomeDirectoryDetails homeDirectoryDetails) {
        this(homeDirectoryDetails, new DefaultHomeSubdirectoryResolver());
    }

    private HomeLayout(HomeDirectoryDetails homeDirectoryDetails, HomeSubdirectoryResolver resolver) {
        this.homeDir = homeDirectoryDetails.getHome();
        this.sharedHomeDir = homeDirectoryDetails.getSharedHome();
        log.debug("Running with Home Directory = {}, Shared Home Directory = {}", (Object)this.homeDir, (Object)this.sharedHomeDir);
        this.binDir = resolver.resolve(this.homeDir, "bin");
        this.cacheDir = resolver.resolve(this.homeDir, "caches");
        this.exportDir = resolver.resolve(this.homeDir, "export");
        this.libDir = resolver.resolve(this.homeDir, "lib");
        this.nativeDir = resolver.resolve(this.libDir, "native");
        this.logDir = resolver.resolve(this.homeDir, LOG_PATH);
        this.pluginsDir = resolver.resolve(this.homeDir, PLUGINS_DIR_NAME);
        this.osgiCacheDir = resolver.create(this.pluginsDir, ".osgi-cache");
        this.bundledPluginsDir = this.pluginsDir.resolve(".bundled-plugins");
        this.configDir = resolver.resolve(this.sharedHomeDir, CONFIG_DIR_NAME);
        this.upgradesDir = resolver.create(this.configDir, "upgrades");
        this.dataDir = resolver.resolve(this.sharedHomeDir, DATA_DIR_NAME);
        this.attachmentsDir = resolver.create(this.dataDir, "attachments");
        this.hierarchiesDir = resolver.create(this.dataDir, "hierarchies");
        this.reposDir = resolver.create(this.dataDir, REPOSITORIES_DIR_NAME);
        this.sharedPluginsDir = resolver.create(this.sharedHomeDir, PLUGINS_DIR_NAME);
        this.installedPluginsDir = resolver.create(this.sharedPluginsDir, INSTALLED_PLUGINS_DIR_NAME);
        this.tempDir = resolver.resolve(this.homeDir, "tmp");
    }

    public void cleanup() {
        if (Files.isDirectory(this.bundledPluginsDir, new LinkOption[0])) {
            try {
                MoreFiles.deleteRecursively((Path)this.bundledPluginsDir);
                log.debug("Deleted legacy bundled plugins directory at {}", (Object)this.bundledPluginsDir.toAbsolutePath());
            }
            catch (IOException e) {
                log.warn("The legacy bundled plugins directory at {} could not be removed. It should be removed by an administrator as it is no longer used", (Object)this.bundledPluginsDir.toAbsolutePath(), (Object)e);
            }
        }
    }

    @Nonnull
    public Path getAttachmentsDir() {
        return this.attachmentsDir;
    }

    @Nonnull
    public Path getBackupDir() {
        return this.exportDir;
    }

    @Nonnull
    public Path getBinDir() {
        return this.binDir;
    }

    @Nonnull
    public Path getBundledPluginsDir() {
        return this.bundledPluginsDir;
    }

    @Nonnull
    public Path getCacheDir() {
        return this.cacheDir;
    }

    @Nonnull
    public Path getConfigDir() {
        return this.configDir;
    }

    @Nonnull
    public Path getDataDir() {
        return this.dataDir;
    }

    @Nonnull
    public Path getExportDir() {
        return this.exportDir;
    }

    @Nonnull
    public Path getHierarchiesDir() {
        return this.hierarchiesDir;
    }

    @Nonnull
    public Path getHierarchyDataDir(@Nonnull String hierarchyId) {
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        return this.getHierarchiesDir().resolve(hierarchyId.substring(0, 2)).resolve(hierarchyId.substring(2));
    }

    @Nonnull
    public Path getHierarchyDataDir(@Nonnull Repository repository) {
        String hierarchyId = Objects.requireNonNull(repository, "repository").getHierarchyId();
        return this.getHierarchyDataDir(hierarchyId).resolve(Integer.toString(repository.getId()));
    }

    @Nonnull
    public Path getHomeDir() {
        return this.homeDir;
    }

    @Nonnull
    public Path getInstalledPluginsDir() {
        return this.installedPluginsDir;
    }

    @Nonnull
    public Path getLibDir() {
        return this.libDir;
    }

    @Nonnull
    public Path getLogDir() {
        return this.logDir;
    }

    @Nonnull
    public Path getNativeDir() {
        return this.nativeDir;
    }

    @Nonnull
    public Path getOsgiCacheDir() {
        return this.osgiCacheDir;
    }

    @Nonnull
    public Path getPluginsDir() {
        return this.pluginsDir;
    }

    @Nonnull
    public Path getRepositoriesDir() {
        return this.reposDir;
    }

    @Nonnull
    public Path getRepositoryDir(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return this.getRepositoriesDir().resolve(Integer.toString(repository.getId()));
    }

    public Path getSharedHomeDir() {
        return this.sharedHomeDir;
    }

    @Nonnull
    public Path getSharedPluginsDir() {
        return this.sharedPluginsDir;
    }

    @Nonnull
    public Path getTempDir() {
        return this.tempDir;
    }

    @Nonnull
    public Path getUpgradesDir() {
        return this.upgradesDir;
    }
}

