/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.analytics;

import com.atlassian.analytics.api.extractor.ProductProvidedPropertyExtractor;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.auth.AbstractAuthenticationEvent;
import com.atlassian.bitbucket.project.AbstractProjectVisitor;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.stash.internal.analytics.DraftPullRequestAnalyticsUtils;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=ProductProvidedPropertyExtractor.class)
@Component(value="bitbucketProductProvidedPropertyExtractor")
public class BitbucketProductProvidedPropertyExtractor
implements ProductProvidedPropertyExtractor {
    private final UserManager userManager;

    public BitbucketProductProvidedPropertyExtractor(UserManager userManager) {
        this.userManager = userManager;
    }

    public Map<String, Object> extractProperty(final @Nonnull String name, @Nonnull Object value) {
        if (value instanceof ApplicationUser) {
            ApplicationUser user = (ApplicationUser)value;
            return Map.of(name + ".id", String.valueOf(user.getId()));
        }
        if (value instanceof Project) {
            Project project = (Project)value;
            ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)(name + ".id"), (Object)String.valueOf(project.getId())).put((Object)(name + ".type"), (Object)project.getType());
            PersonalProject personalProject = (PersonalProject)project.accept((ProjectVisitor)new AbstractProjectVisitor<PersonalProject>(this){

                public PersonalProject visit(@Nonnull PersonalProject project) {
                    return project;
                }
            });
            if (personalProject != null) {
                builder.putAll(this.extractProperty(name + ".owner", personalProject.getOwner()));
            }
            return builder.build();
        }
        if (value instanceof Repository) {
            Repository repository = (Repository)value;
            return ImmutableMap.builder().put((Object)(name + ".id"), (Object)String.valueOf(repository.getId())).put((Object)(name + ".remote"), (Object)repository.isRemote()).putAll(this.extractProperty(name + ".project", repository.getProject())).build();
        }
        if (value instanceof Scope) {
            Scope scope = (Scope)value;
            final ImmutableMap.Builder scopeBuilder = ImmutableMap.builder().put((Object)this.getScopeName(name, "scopeType"), (Object)scope.getType().name());
            scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

                public Void visit(@Nonnull ProjectScope scope) {
                    scopeBuilder.putAll(BitbucketProductProvidedPropertyExtractor.this.extractProperty(BitbucketProductProvidedPropertyExtractor.this.getScopeName(name, "project"), scope.getProject()));
                    return null;
                }

                public Void visit(@Nonnull RepositoryScope scope) {
                    scopeBuilder.putAll(BitbucketProductProvidedPropertyExtractor.this.extractProperty(BitbucketProductProvidedPropertyExtractor.this.getScopeName(name, "repository"), scope.getRepository()));
                    return null;
                }
            });
            return scopeBuilder.build();
        }
        if (value instanceof PullRequest) {
            PullRequest pullRequest = (PullRequest)value;
            return ImmutableMap.builder().putAll(this.extractProperty(name + ".fromRef.repository", pullRequest.getFromRef().getRepository())).put((Object)(name + ".id"), (Object)String.valueOf(pullRequest.getId())).put((Object)(name + ".draft"), (Object)pullRequest.isDraft()).put((Object)(name + ".draftByTitle"), (Object)DraftPullRequestAnalyticsUtils.isDraftByTitle(pullRequest.getTitle())).put((Object)(name + ".participants.size"), (Object)String.valueOf(pullRequest.getParticipants().size())).put((Object)(name + ".reviewers.size"), (Object)String.valueOf(pullRequest.getReviewers().size())).putAll(this.extractProperty(name + ".toRef.repository", pullRequest.getToRef().getRepository())).build();
        }
        if (value instanceof PullRequestParticipant) {
            PullRequestParticipant participant = (PullRequestParticipant)value;
            return ImmutableMap.builder().putAll(this.extractProperty(name + ".user", participant.getUser())).put((Object)(name + ".role"), (Object)participant.getRole()).put((Object)(name + ".status"), (Object)participant.getStatus()).put((Object)(name + ".approved"), (Object)participant.isApproved()).build();
        }
        if (value instanceof Comment) {
            Comment comment = (Comment)value;
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            builder.put((Object)(name + ".id"), (Object)String.valueOf(comment.getId()));
            builder.put((Object)(name + ".severity"), (Object)comment.getSeverity());
            builder.put((Object)(name + ".state"), (Object)comment.getState());
            builder.put((Object)(name + ".text.length"), (Object)String.valueOf(comment.getText().length()));
            comment.getAnchor().ifPresent(anchor -> {
                builder.put((Object)(name + ".thread.anchor.diffType"), (Object)anchor.getDiffType());
                anchor.getFileType().ifPresent(fileType -> builder.put((Object)(name + ".thread.anchor.fileType"), fileType));
                anchor.getLineType().ifPresent(lineType -> builder.put((Object)(name + ".thread.anchor.lineType"), lineType));
                builder.put((Object)(name + ".thread.anchor.lineComment"), (Object)anchor.isLineAnchor());
                builder.put((Object)(name + ".thread.anchor.multilineComment"), (Object)anchor.isMultilineAnchor());
            });
            return builder.build();
        }
        return null;
    }

    public String extractUser(@Nonnull Object event, @Nonnull Map<String, Object> properties) {
        if (event instanceof ApplicationEvent) {
            ApplicationUser user = ((ApplicationEvent)event).getUser();
            if (user != null) {
                return user.getName();
            }
            if (event instanceof AbstractAuthenticationEvent) {
                return ((AbstractAuthenticationEvent)event).getUsername();
            }
            return null;
        }
        return this.getRemoteUser();
    }

    private static String nullToEmpty(Object o) {
        return o == null ? "" : o.toString();
    }

    private String getRemoteUser() {
        UserProfile remoteUser = this.userManager.getRemoteUser();
        if (remoteUser == null) {
            return null;
        }
        return remoteUser.getUsername();
    }

    private String getScopeName(String name, String appendedName) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"scope", (CharSequence)name)) {
            return appendedName;
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)"scope")) {
            return name.substring(0, name.length() - 5) + StringUtils.capitalize((String)appendedName);
        }
        return name + StringUtils.capitalize((String)appendedName);
    }
}

