/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.ao;

import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nullable;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDataSourceProvider
implements DataSourceProvider {
    protected static final Logger log = LoggerFactory.getLogger(ApplicationDataSourceProvider.class);
    private static final Map<String, DatabaseType> URL_PREFIX_TO_TYPE_MAP = ImmutableMap.builder().put((Object)"jdbc:h2:", (Object)DatabaseType.H2).put((Object)"jdbc:hsqldb:", (Object)DatabaseType.HSQL).put((Object)"jdbc:oracle:", (Object)DatabaseType.ORACLE).put((Object)"jdbc:postgresql:", (Object)DatabaseType.POSTGRESQL).put((Object)"jdbc:jtds:sqlserver:", (Object)DatabaseType.MS_SQL).put((Object)"jdbc:sqlserver:", (Object)DatabaseType.MS_SQL).build();
    private final DataSource dataSource;
    private final DataSourceConfiguration dataSourceConfiguration;

    public ApplicationDataSourceProvider(DataSource dataSource, DataSourceConfiguration dataSourceConfiguration) {
        this.dataSource = dataSource;
        this.dataSourceConfiguration = dataSourceConfiguration;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DatabaseType getDatabaseType() {
        String url = this.dataSourceConfiguration.getUrl();
        if (url != null) {
            for (Map.Entry<String, DatabaseType> entry : URL_PREFIX_TO_TYPE_MAP.entrySet()) {
                if (!url.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        log.warn("Could not determine database type for {}", (Object)url);
        return DatabaseType.UNKNOWN;
    }

    @Nullable
    public String getSchema() {
        return null;
    }
}

