/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.aop;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.DataStoreException;
import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.comment.CommentOutOfDateException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.pull.PullRequestOutOfDateException;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import jakarta.persistence.PersistenceException;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.StaleObjectStateException;
import org.springframework.aop.ThrowsAdvice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;

@Component(value="exceptionRewriteAdvice")
public class ExceptionRewriteAdvice
implements ThrowsAdvice {
    private final I18nService i18nService;

    @Autowired
    public ExceptionRewriteAdvice(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public void afterThrowing(AccessDeniedException e) {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.accessdenied", new Object[0]);
        throw new AuthorisationException(message, (Throwable)e);
    }

    public void afterThrowing(DataAccessException e) {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.datastorefail", new Object[0]);
        throw new DataStoreException(message, (Throwable)e);
    }

    public void afterThrowing(HibernateException e) {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.datastorefail", new Object[0]);
        throw new DataStoreException(message, (Throwable)e);
    }

    public void afterThrowing(ObjectOptimisticLockingFailureException e) {
        throw this.getSpecificOutOfDateException((Exception)e);
    }

    public void afterThrowing(StaleObjectStateException e) {
        throw this.getSpecificOutOfDateException((Exception)e);
    }

    public void afterThrowing(PersistenceException e) {
        Throwable cause = e.getCause();
        if (cause instanceof StaleObjectStateException) {
            this.afterThrowing((StaleObjectStateException)cause);
        } else if (cause instanceof ObjectOptimisticLockingFailureException) {
            this.afterThrowing((ObjectOptimisticLockingFailureException)cause);
        } else if (cause instanceof DataAccessException) {
            this.afterThrowing((DataAccessException)cause);
        } else if (cause instanceof HibernateException) {
            this.afterThrowing((HibernateException)cause);
        }
    }

    private EntityOutOfDateException getSpecificOutOfDateException(Exception e) {
        if (this.isForEntity(e, InternalPullRequest.class)) {
            return new PullRequestOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.outofdate", new Object[0]), (Throwable)e);
        }
        if (this.isForEntity(e, InternalComment.class)) {
            return new CommentOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.comment.outofdate", new Object[0]), (Throwable)e);
        }
        return new EntityOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.entity.outofdate", new Object[0]), (Throwable)e);
    }

    private boolean isForEntity(Exception e, Class<?> clazz) {
        if (e instanceof ObjectOptimisticLockingFailureException) {
            ObjectOptimisticLockingFailureException exception = (ObjectOptimisticLockingFailureException)e;
            return Objects.equals(clazz.getName(), exception.getPersistentClassName());
        }
        if (e instanceof StaleObjectStateException) {
            StaleObjectStateException exception = (StaleObjectStateException)e;
            return Objects.equals(clazz.getName(), exception.getEntityName());
        }
        return false;
    }
}

