/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.aop;

import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=7)
public class ProfilingAspect {
    @Pointcut(value="@within(org.springframework.stereotype.Repository)")
    public void daoType() {
    }

    @Pointcut(value="@annotation(com.atlassian.stash.internal.annotation.NotProfiled)")
    public void notProfiledMethod() {
    }

    @Pointcut(value="@within(com.atlassian.stash.internal.annotation.NotProfiled)")
    public void notProfiledType() {
    }

    @Around(value="!notProfiledMethod () && (profiledMethod() || ((daoType() || serviceType() || profiledType()) && !notProfiledType()))")
    public Object profileMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        if (TimerUtils.isActive()) {
            try (Ticker ignored = Timers.start((String)joinPoint.getSignature().toString());){
                Object object = joinPoint.proceed();
                return object;
            }
        }
        return joinPoint.proceed();
    }

    @Pointcut(value="@annotation(com.atlassian.stash.internal.annotation.Profiled)")
    public void profiledMethod() {
    }

    @Pointcut(value="@within(com.atlassian.stash.internal.annotation.Profiled)")
    public void profiledType() {
    }

    @Pointcut(value="@within(org.springframework.stereotype.Service)")
    public void serviceType() {
    }
}

