/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.aop;

import com.atlassian.bitbucket.dmz.features.DarkFeatureUnavailableException;
import com.atlassian.bitbucket.dmz.features.RequireDarkFeature;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.sal.api.features.DarkFeatureManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=3)
@Component
public class RequireDarkFeatureAspect {
    private static final Logger log = LoggerFactory.getLogger(RequireDarkFeatureAspect.class);
    private final DarkFeatureManager darkFeatureManager;
    private final I18nService i18nService;

    public RequireDarkFeatureAspect(DarkFeatureManager darkFeatureManager, I18nService i18nService) {
        this.darkFeatureManager = darkFeatureManager;
        this.i18nService = i18nService;
    }

    @Before(argNames="joinPoint,annotation", value="@annotation(annotation)")
    public void requireDarkFeatureForMethod(JoinPoint joinPoint, RequireDarkFeature annotation) {
        this.requireDarkFeature(joinPoint, annotation);
    }

    @Before(argNames="joinPoint,annotation", value="@within(annotation) && !@annotation(com.atlassian.bitbucket.dmz.features.RequireDarkFeature)")
    public void requireDarkFeatureForType(JoinPoint joinPoint, RequireDarkFeature annotation) {
        this.requireDarkFeature(joinPoint, annotation);
    }

    private void requireDarkFeature(JoinPoint joinPoint, RequireDarkFeature annotation) {
        if (annotation.skip()) {
            log.trace("Skipping dark feature check for join point [{}]", (Object)joinPoint.getSignature());
        } else {
            boolean enabled = this.darkFeatureManager.isEnabledForCurrentUser(annotation.value()).orElse(Boolean.FALSE);
            if (enabled) {
                log.trace("Dark feature [{}] is available, allowing [{}] to run", (Object)annotation.value(), (Object)joinPoint.getSignature());
            } else {
                throw new DarkFeatureUnavailableException(this.i18nService.createKeyedMessage("bitbucket.service.dark.feature.disabled", new Object[0]));
            }
        }
    }
}

