/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.aop;

import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.google.common.annotations.VisibleForTesting;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=4)
@Component
public class RequireFeatureAspect {
    private static final Logger log = LoggerFactory.getLogger(RequireFeatureAspect.class);
    private final FeatureManager featureManager;

    @Autowired
    public RequireFeatureAspect(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    @Before(argNames="joinPoint,annotation", value="@annotation(annotation)")
    public void requireFeatureForMethod(JoinPoint joinPoint, RequireFeature annotation) {
        this.requireFeature(joinPoint, (Feature)annotation.value(), annotation.skip());
    }

    @Before(argNames="joinPoint,annotation", value="@within(annotation) && !@annotation(com.atlassian.bitbucket.dmz.features.RequireFeature)")
    public void requireFeatureForType(JoinPoint joinPoint, RequireFeature annotation) {
        this.requireFeature(joinPoint, (Feature)annotation.value(), annotation.skip());
    }

    @VisibleForTesting
    void requireFeature(JoinPoint joinPoint, Feature feature, boolean skip) {
        if (skip) {
            log.trace("Skipping enabled check for join point [{}]", (Object)this.getDescription(joinPoint));
        } else {
            this.featureManager.requireEnabled(feature);
            log.trace("Feature [{}] is enabled, allowing [{}] to run", (Object)feature.getKey(), (Object)this.getDescription(joinPoint));
        }
    }

    private String getDescription(JoinPoint joinPoint) {
        return String.format("Executing [%s] requires Data Center license", joinPoint.getSignature());
    }
}

