/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.aop;

import com.atlassian.bitbucket.dmz.throttle.DmzThrottleService;
import com.atlassian.bitbucket.dmz.throttle.Ticket;
import com.atlassian.stash.internal.annotation.Throttled;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=6)
public class ThrottledAspect {
    private final DmzThrottleService throttleService;

    @Autowired
    public ThrottledAspect(DmzThrottleService throttleService) {
        this.throttleService = throttleService;
    }

    public Object throttle(ProceedingJoinPoint invocation, Throttled annotation) throws Throwable {
        try (Ticket ignored = this.throttleService.acquireTicket(annotation.value());){
            Object object = invocation.proceed();
            return object;
        }
    }
}

