/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.applinks.spi;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.application.stash.StashApplicationType;
import com.atlassian.applinks.api.application.stash.StashProjectEntityType;
import com.atlassian.applinks.host.spi.AbstractInternalHostApplication;
import com.atlassian.applinks.host.spi.DefaultEntityReference;
import com.atlassian.applinks.host.spi.EntityReference;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(interfaces={InternalHostApplication.class, HostApplication.class})
@Component(value="hostApplication")
public class StashHostApplication
extends AbstractInternalHostApplication {
    private final ApplicationPropertiesService applicationPropertiesService;
    private final PermissionService permissionService;
    private final ProjectService projectService;
    private final SecurityService securityService;
    private final TypeAccessor typeAccessor;
    private volatile ApplicationId applicationId;

    @Autowired
    public StashHostApplication(PluginAccessor pluginAccessor, ApplicationPropertiesService applicationPropertiesService, ProjectService projectService, PermissionService permissionService, SecurityService securityService, TypeAccessor typeAccessor) {
        super(pluginAccessor);
        this.applicationPropertiesService = applicationPropertiesService;
        this.permissionService = permissionService;
        this.projectService = projectService;
        this.securityService = securityService;
        this.typeAccessor = typeAccessor;
    }

    public boolean canManageEntityLinksFor(EntityReference entityReference) {
        try {
            if (entityReference.getType() instanceof StashProjectEntityType) {
                Project project = this.findProject(entityReference.getKey());
                return project != null && this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN);
            }
        }
        catch (AuthorisationException authorisationException) {
            // empty catch block
        }
        return false;
    }

    public boolean doesEntityExist(String key, Class<? extends EntityType> type) {
        try {
            return this.findEntity(key, type) != null;
        }
        catch (AuthorisationException e) {
            return false;
        }
    }

    public boolean doesEntityExistNoPermissionCheck(final String key, final Class<? extends EntityType> type) {
        return (Boolean)this.securityService.withPermission(Permission.PROJECT_VIEW, "Promoting privilege for UAL").call((Operation)new UncheckedOperation<Boolean>(){

            public Boolean perform() throws RuntimeException {
                return StashHostApplication.this.doesEntityExist(key, type);
            }
        });
    }

    public URI getBaseUrl() {
        return this.applicationPropertiesService.getBaseUrl();
    }

    public URI getDocumentationBaseUrl() {
        return URI.create("http://confluence.atlassian.com/display/APPLINKS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationId getId() {
        if (this.applicationId == null) {
            StashHostApplication stashHostApplication = this;
            synchronized (stashHostApplication) {
                if (this.applicationId == null) {
                    byte[] sidBytes = this.applicationPropertiesService.getServerId().getBytes();
                    this.applicationId = new ApplicationId(UUID.nameUUIDFromBytes(sidBytes).toString());
                }
            }
        }
        return this.applicationId;
    }

    public Iterable<EntityReference> getLocalEntities() {
        return new PagedIterable((PageProvider)new PageProvider<EntityReference>(){

            public Page<EntityReference> get(PageRequest request) {
                return StashHostApplication.this.projectService.findAll(request).transform(project -> StashHostApplication.this.createProjectEntityReference((Project)project));
            }
        }, 100);
    }

    public String getName() {
        return this.applicationPropertiesService.getDisplayName();
    }

    public ApplicationType getType() {
        return this.typeAccessor.getApplicationType(StashApplicationType.class);
    }

    public boolean hasPublicSignup() {
        return this.applicationPropertiesService.isAllowPublicSignUp();
    }

    public EntityReference toEntityReference(Object domainObject) {
        if (domainObject instanceof Project) {
            Project project = (Project)domainObject;
            return this.createProjectEntityReference(project);
        }
        return null;
    }

    public EntityReference toEntityReference(String key, Class<? extends EntityType> type) {
        return this.findEntity(key, type);
    }

    private EntityReference createProjectEntityReference(Project project) {
        return new DefaultEntityReference(project.getKey(), project.getName(), (EntityType)Objects.requireNonNull((StashProjectEntityType)this.typeAccessor.getEntityType(StashProjectEntityType.class), StashProjectEntityType.class.getSimpleName() + " not installed!"));
    }

    private EntityReference findEntity(String key, Class<? extends EntityType> type) {
        if (StashProjectEntityType.class.isAssignableFrom(type)) {
            Project project = this.findProject(key);
            return project != null ? this.createProjectEntityReference(project) : null;
        }
        return null;
    }

    private Project findProject(String entityReferenceKey) {
        return this.projectService.getByKey(entityReferenceKey);
    }
}

