/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.atst;

import com.atlassian.stash.internal.atst.SupportDataConstraints;

class DefaultSupportDataConstraints
implements SupportDataConstraints {
    private final long cutoffTime;
    private final long maxRepositories;
    private long added;

    DefaultSupportDataConstraints(long maxRepositories, long cutoffTime) {
        this.cutoffTime = cutoffTime;
        this.maxRepositories = maxRepositories;
    }

    @Override
    public boolean addProject() {
        return this.isRunning();
    }

    @Override
    public boolean addRepository() {
        if (this.isRunning()) {
            ++this.added;
            return true;
        }
        return false;
    }

    long getCutoffTime() {
        return this.cutoffTime;
    }

    long getMaxRepositories() {
        return this.maxRepositories;
    }

    private boolean isRunning() {
        return System.currentTimeMillis() < this.cutoffTime && this.added < this.maxRepositories;
    }
}

