/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.atst;

import com.atlassian.stash.internal.atst.DefaultSupportDataConstraints;
import com.atlassian.stash.internal.atst.SupportDataConstraints;
import com.atlassian.stash.internal.atst.SupportDataHelper;
import com.atlassian.stash.internal.atst.UnlimitedSupportDataConstraints;
import com.atlassian.troubleshooting.spi.SupportDataBuilderContext;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="supportDataHelper")
public class DefaultSupportDataHelper
implements SupportDataHelper {
    static final String CTX_CONSTRAINTS = "bitbucket.atst.constraints";
    private static final String PROP_PREFIX = "atst.constraint.";
    private static final String PROP_MAX_REPOSITORIES = "${atst.constraint.max.repositories}";
    private static final String PROP_TIMEOUT = "${atst.constraint.timeout}";
    private final long maxRepositories;
    private final long timeout;

    @Autowired
    public DefaultSupportDataHelper(@Value(value="${atst.constraint.max.repositories}") long maxRepositories, @Value(value="${atst.constraint.timeout}") long timeout) {
        this.maxRepositories = maxRepositories < 0L ? Long.MAX_VALUE : maxRepositories;
        this.timeout = timeout > 0L ? TimeUnit.SECONDS.toMillis(Math.max(timeout, 30L)) : -1L;
    }

    @Override
    @Nonnull
    public SupportDataConstraints getConstraints(@Nonnull SupportDataBuilderContext context) {
        SupportDataConstraints constraints = (SupportDataConstraints)Objects.requireNonNull(context, "context").getProperty(CTX_CONSTRAINTS, null);
        if (constraints == null) {
            constraints = this.maxRepositories == Long.MAX_VALUE && this.timeout == -1L ? new UnlimitedSupportDataConstraints() : new DefaultSupportDataConstraints(this.maxRepositories, this.timeout == -1L ? Long.MAX_VALUE : context.getStart().getTime() + this.timeout);
            context.setProperty(CTX_CONSTRAINTS, (Object)constraints);
        }
        return constraints;
    }
}

