/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.atst;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.troubleshooting.spi.HostApplication;
import io.atlassian.util.concurrent.LazyReference;
import java.util.concurrent.Callable;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=HostApplication.class)
@Component(value="supportHostApplication")
public class SupportHostApplication
implements HostApplication {
    private final ApplicationModeSupplier applicationModeSupplier;
    private final SecurityService securityService;
    private final UserService userService;

    public SupportHostApplication(ApplicationModeSupplier applicationModeSupplier, SecurityService securityService, UserService userService) {
        this.applicationModeSupplier = applicationModeSupplier;
        this.securityService = securityService;
        this.userService = userService;
    }

    public <T> Callable<T> asUser(String username, Callable<T> operation) {
        return username == null ? operation : new RunAsCallable(operation, username);
    }

    private class RunAsCallable<T>
    implements Callable<T> {
        private final Callable<T> operation;
        private final LazyReference<ApplicationUser> userRef;

        private RunAsCallable(Callable<T> operation, final String username) {
            this.operation = operation;
            this.userRef = new LazyReference<ApplicationUser>(){

                protected ApplicationUser create() {
                    ApplicationUser user = SupportHostApplication.this.userService.getUserByName(username);
                    if (user == null) {
                        user = SupportHostApplication.this.userService.getServiceUserByName(username);
                    }
                    return user;
                }
            };
        }

        @Override
        public T call() throws Exception {
            ApplicationUser user = (ApplicationUser)this.userRef.get();
            if (user == null) {
                return this.operation.call();
            }
            EscalatedSecurityContext context = SupportHostApplication.this.securityService.impersonating(user, "for ATST");
            if (SupportHostApplication.this.applicationModeSupplier.getMode() == ApplicationMode.MIRROR && user.getType() == UserType.SERVICE) {
                context = context.withPermission(Permission.SYS_ADMIN);
            }
            return (T)context.call(this.operation::call);
        }
    }
}

