/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.concurrent.StateTransferringCallable;
import com.atlassian.stash.internal.concurrent.StateTransferringRunnable;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.concurrent.TransferableStateManager;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.concurrent.Callable;

abstract class AbstractTransferableStateManager
implements TransferableStateManager {
    AbstractTransferableStateManager() {
    }

    @Override
    @Nonnull
    public Runnable wrap(@Nonnull Runnable runnable) {
        return new StateTransferringRunnable(runnable, this.getState());
    }

    @Override
    @Nonnull
    public <T> Callable<T> wrap(@Nonnull Callable<T> callable) {
        return new StateTransferringCallable<T>(callable, this.getState());
    }

    @Override
    @Nonnull
    public <T> Collection<Callable<T>> wrap(@Nonnull Collection<? extends Callable<T>> callables) {
        TransferableState state = this.getState();
        return (Collection)callables.stream().map(callable -> new StateTransferringCallable(callable, state)).collect(MoreCollectors.toImmutableList());
    }
}

