/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.ConfigurableThreadFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class ConcurrencyUtils {
    private ConcurrencyUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class");
    }

    @Nonnull
    public static ThreadFactory createDaemonThreadFactory(@Nonnull String prefix) {
        return ConcurrencyUtils.createDaemonThreadFactory(prefix, null, null);
    }

    @Nonnull
    public static ThreadFactory createDaemonThreadFactory(@Nonnull String prefix, @Nullable ThreadGroup threadGroup) {
        return ConcurrencyUtils.createDaemonThreadFactory(prefix, threadGroup, null);
    }

    @Nonnull
    public static ThreadFactory createDaemonThreadFactory(@Nonnull String prefix, @Nullable ThreadGroup threadGroup, @Nullable ClassLoader classLoader) {
        ConfigurableThreadFactory threadFactory = new ConfigurableThreadFactory(classLoader);
        threadFactory.setDaemon(true);
        threadFactory.setThreadNamePrefix(prefix);
        threadFactory.setThreadGroup(threadGroup);
        return threadFactory;
    }

    @Nonnull
    public static ScheduledExecutorService createScheduledExecutor(@Nonnull String prefix) {
        return ConcurrencyUtils.createScheduledExecutor(ConcurrencyUtils.createDaemonThreadFactory(prefix));
    }

    @Nonnull
    public static ScheduledExecutorService createScheduledExecutor(@Nonnull String prefix, @Nullable ThreadGroup threadGroup) {
        return ConcurrencyUtils.createScheduledExecutor(ConcurrencyUtils.createDaemonThreadFactory(prefix, threadGroup));
    }

    @Nonnull
    public static ScheduledExecutorService createScheduledExecutor(@Nonnull ThreadFactory threadFactory) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }
}

