/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class ConfigurableThreadFactory
extends CustomizableThreadFactory {
    private ClassLoader classLoader;

    public ConfigurableThreadFactory() {
    }

    public ConfigurableThreadFactory(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Nonnull
    public Thread createThread(@Nonnull Runnable runnable) {
        Thread thread = super.createThread(runnable);
        thread.setContextClassLoader(this.classLoader);
        return thread;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        if ((threadNamePrefix = StringUtils.trimToNull((String)threadNamePrefix)) != null) {
            threadNamePrefix = (String)threadNamePrefix + ":" + this.getDefaultThreadNamePrefix();
        }
        super.setThreadNamePrefix((String)threadNamePrefix);
    }

    @Nonnull
    protected String getDefaultThreadNamePrefix() {
        return "thread-";
    }
}

