/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.concurrent.TransferableStateManager;
import jakarta.annotation.Nonnull;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=ThreadLocalContextManager.class)
@Component(value="threadLocalContextManager")
public class DefaultThreadLocalContextManager
implements ThreadLocalContextManager<Object> {
    private final TransferableStateManager transferableStateManager;

    public DefaultThreadLocalContextManager(TransferableStateManager transferableStateManager) {
        this.transferableStateManager = transferableStateManager;
    }

    public void clearThreadLocalContext() {
        this.transferableStateManager.getState().remove();
    }

    @Nonnull
    public TransferableState getThreadLocalContext() {
        return this.transferableStateManager.getState();
    }

    public void setThreadLocalContext(Object context) {
        if (context instanceof TransferableState) {
            TransferableState currentThreadState = (TransferableState)context;
            currentThreadState.apply();
        }
    }
}

