/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.AbstractTransferableStateManager;
import com.atlassian.stash.internal.concurrent.CompositeTransferableState;
import com.atlassian.stash.internal.concurrent.StatefulService;
import jakarta.annotation.Nonnull;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class DefaultTransferableStateManager
extends AbstractTransferableStateManager
implements BeanPostProcessor {
    private final Set<StatefulService> services = new CopyOnWriteArraySet<StatefulService>();

    @Override
    @Nonnull
    public CompositeTransferableState getState() {
        return CompositeTransferableState.from(this.services);
    }

    public Object postProcessAfterInitialization(@Nonnull Object bean, @Nonnull String beanName) throws BeansException {
        if (bean instanceof StatefulService) {
            this.services.add((StatefulService)bean);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(@Nonnull Object bean, @Nonnull String beanName) throws BeansException {
        return bean;
    }
}

