/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.PauseableExecutorService;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class PauseableThreadPoolExecutor
extends ThreadPoolExecutor
implements PauseableExecutorService {
    private AtomicLong pauseUntil = new AtomicLong(0L);

    public PauseableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public PauseableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public PauseableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public PauseableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    public void pauseFor(long pauseTime, TimeUnit unit) {
        this.pauseUntil.set(this.currentTimeMillis() + unit.toMillis(pauseTime));
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        try {
            long now = this.currentTimeMillis();
            while (now < this.pauseUntil.get()) {
                long pauseFor = this.pauseUntil.get() - now;
                if (pauseFor > 0L) {
                    Thread.sleep(pauseFor);
                }
                now = this.currentTimeMillis();
            }
        }
        catch (InterruptedException e) {
            t.interrupt();
        }
    }

    @VisibleForTesting
    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

