/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.TransferableState;
import jakarta.annotation.Nonnull;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateTransferringCallable<T>
implements Callable<T> {
    private static final Logger log = LoggerFactory.getLogger(StateTransferringCallable.class);
    private final Callable<T> delegate;
    private final TransferableState state;

    StateTransferringCallable(@Nonnull Callable<T> delegate, @Nonnull TransferableState state) {
        this.delegate = delegate;
        this.state = state;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T call() throws Exception {
        try {
            this.state.apply();
            try {
                T t = this.delegate.call();
                return t;
            }
            finally {
                this.state.remove();
            }
        }
        catch (Error | Exception e) {
            log.debug("Error while processing asynchronous task", e);
            throw e;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StateTransferringCallable) {
            StateTransferringCallable that = (StateTransferringCallable)o;
            return this.delegate.equals(that.delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

