/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.TransferableStateManager;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class StateTransferringExecutorService
implements ExecutorService {
    private final ExecutorService delegate;
    private final TransferableStateManager transferableStateManager;

    public StateTransferringExecutorService(ExecutorService delegate, TransferableStateManager transferableStateManager) {
        this.delegate = delegate;
        this.transferableStateManager = transferableStateManager;
    }

    @Override
    public boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(@Nonnull Runnable runnable) {
        this.delegate.execute(this.wrap(runnable));
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrap(tasks));
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrap(tasks), timeout, unit);
    }

    @Override
    @Nonnull
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrap(tasks));
    }

    @Override
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrap(tasks), timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(@Nonnull Callable<T> callable) {
        return this.delegate.submit(this.wrap(callable));
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(@Nonnull Runnable runnable, T t) {
        return this.delegate.submit(this.wrap(runnable), t);
    }

    @Override
    @Nonnull
    public Future<?> submit(@Nonnull Runnable runnable) {
        return this.delegate.submit(this.wrap(runnable));
    }

    protected <T> Callable<T> wrap(Callable<T> callable) {
        return this.transferableStateManager.wrap(callable);
    }

    protected <T> Collection<Callable<T>> wrap(Collection<? extends Callable<T>> callables) {
        return this.transferableStateManager.wrap(callables);
    }

    protected Runnable wrap(Runnable runnable) {
        return this.transferableStateManager.wrap(runnable);
    }
}

