/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.TransferableState;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateTransferringRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(StateTransferringRunnable.class);
    private final Runnable delegate;
    private final TransferableState state;

    StateTransferringRunnable(@Nonnull Runnable delegate, @Nonnull TransferableState state) {
        this.delegate = delegate;
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StateTransferringRunnable) {
            StateTransferringRunnable that = (StateTransferringRunnable)o;
            return this.delegate.equals(that.delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public void run() {
        try {
            this.state.apply();
            try {
                this.delegate.run();
            }
            finally {
                this.state.remove();
            }
        }
        catch (Error | RuntimeException e) {
            log.error("Error while processing asynchronous task", e);
            throw e;
        }
    }
}

