/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.darkfeature;

import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.sal.api.features.SiteDarkFeaturesStorage;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ClusteredSiteDarkFeaturesStorage
implements SiteDarkFeaturesStorage {
    static final String SITE_WIDE_DARK_FEATURES = "atlassian.sitewide.dark.features";
    private final CachedReference<ImmutableSet<String>> cache;
    private final PluginSettingsFactory pluginSettingsFactory;

    public ClusteredSiteDarkFeaturesStorage(CacheFactory cacheFactory, PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.cache = cacheFactory.getCachedReference(SiteDarkFeaturesStorage.class.getName(), this::load, new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().build());
    }

    public boolean contains(String featureKey) {
        featureKey = ClusteredSiteDarkFeaturesStorage.requireFeatureKey(featureKey);
        return ((ImmutableSet)this.cache.get()).contains((Object)featureKey);
    }

    public void disable(String featureKey) {
        if (this.maybeUpdate(featureKey = ClusteredSiteDarkFeaturesStorage.requireFeatureKey(featureKey), false)) {
            this.cache.reset();
        }
    }

    public void enable(String featureKey) {
        if (this.maybeUpdate(featureKey = ClusteredSiteDarkFeaturesStorage.requireFeatureKey(featureKey), true)) {
            this.cache.reset();
        }
    }

    public Set<String> getEnabledDarkFeatureSet() {
        return (Set)this.cache.get();
    }

    private static ImmutableSet<String> extractFeatureKeys(@Nullable Object value) {
        ImmutableSet.Builder featureKeys = ImmutableSet.builder();
        if (value instanceof List) {
            List list = (List)value;
            for (Object listItem : list) {
                if (!(listItem instanceof String)) continue;
                featureKeys.add((Object)((String)listItem));
            }
        }
        return featureKeys.build();
    }

    private static String requireFeatureKey(String featureKey) {
        return Objects.requireNonNull(StringUtils.trimToNull((String)featureKey), "featureKey must not be blank");
    }

    private ImmutableSet<String> load() {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        return ClusteredSiteDarkFeaturesStorage.extractFeatureKeys(globalSettings.get(SITE_WIDE_DARK_FEATURES));
    }

    private synchronized boolean maybeUpdate(String featureKey, boolean enabled) {
        ImmutableSet<String> stored = this.load();
        if (enabled != stored.contains(featureKey)) {
            HashSet<String> updated = new HashSet<String>((Collection<String>)stored);
            if (enabled) {
                updated.add(featureKey);
            } else {
                updated.remove(featureKey);
            }
            this.store(updated);
            return true;
        }
        return false;
    }

    private void store(Set<String> featureKeys) {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        globalSettings.put(SITE_WIDE_DARK_FEATURES, (Object)ImmutableList.copyOf(featureKeys));
    }
}

