/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.darkfeature;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.sal.api.features.EnabledDarkFeatures;
import com.atlassian.sal.api.features.EnabledDarkFeaturesBuilder;
import com.atlassian.sal.api.features.FeatureKeyScope;
import com.atlassian.sal.api.features.FeatureKeyScopePredicate;
import com.atlassian.sal.api.features.MissingPermissionException;
import com.atlassian.sal.api.features.SiteDarkFeaturesStorage;
import com.atlassian.sal.api.features.ValidFeatureKeyPredicate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.core.features.DefaultDarkFeatureManager;
import com.atlassian.stash.internal.darkfeature.InternalDarkFeatureManager;
import com.atlassian.stash.internal.darkfeature.InternalUserDarkFeature;
import com.atlassian.stash.internal.darkfeature.UserDarkFeatureDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class ConfigurableDarkFeatureManager
extends DefaultDarkFeatureManager
implements InternalDarkFeatureManager {
    private final I18nService i18nService;
    private final UserDarkFeatureDao userDarkFeatureDao;
    private final UserManager userManager;
    private final UserService userService;

    public ConfigurableDarkFeatureManager(I18nService i18nService, SiteDarkFeaturesStorage siteDarkFeaturesStorage, UserDarkFeatureDao userDarkFeatureDao, UserManager userManager, UserService userService) {
        super(userManager, siteDarkFeaturesStorage);
        this.userDarkFeatureDao = userDarkFeatureDao;
        this.userManager = userManager;
        this.userService = userService;
        this.i18nService = i18nService;
    }

    @Transactional
    public void disableFeatureForCurrentUser(String featureKey) {
        this.disableFeatureForUser(this.getCurrentUserKey(), featureKey);
    }

    @Transactional
    public void disableFeatureForUser(UserKey userKey, String featureKey) {
        this.updateDarkFeature(userKey, featureKey, false);
    }

    @Transactional
    public void enableFeatureForCurrentUser(String featureKey) {
        this.enableFeatureForUser(this.getCurrentUserKey(), featureKey);
    }

    @Transactional
    public void enableFeatureForUser(UserKey userKey, String featureKey) {
        this.updateDarkFeature(userKey, featureKey, true);
    }

    public EnabledDarkFeatures getFeaturesEnabledForCurrentUser() {
        return this.getFeaturesEnabledForUser(this.getCurrentUserKey());
    }

    public EnabledDarkFeatures getFeaturesEnabledForUser(@Nullable UserKey userKey) {
        if (userKey == null) {
            return super.getFeaturesEnabledForAllUsers();
        }
        ApplicationUser applicationUser = this.userService.getUserById(ConfigurableDarkFeatureManager.getUserId(userKey));
        if (applicationUser == null) {
            throw new IllegalArgumentException(this.i18nService.getMessage("bitbucket.web.user.dark.feature.error.not.existing", new Object[]{userKey.getStringValue()}));
        }
        Map<Boolean, List<InternalUserDarkFeature>> userDarkFeatures = this.userDarkFeatureDao.getByUserId(applicationUser.getId()).stream().collect(Collectors.groupingBy(InternalUserDarkFeature::isEnabled));
        EnabledDarkFeatures featuresEnabledForUser = super.getFeaturesEnabledForAllUsers();
        Set allUsers = featuresEnabledForUser.getFeatureKeys((Predicate)FeatureKeyScopePredicate.filterBy((FeatureKeyScope)FeatureKeyScope.ALL_USERS));
        Set allUsersReadOnly = featuresEnabledForUser.getFeatureKeys((Predicate)FeatureKeyScopePredicate.filterBy((FeatureKeyScope)FeatureKeyScope.ALL_USERS_READ_ONLY));
        Set userDisabledFeatures = (Set)userDarkFeatures.getOrDefault(false, Collections.emptyList()).stream().map(InternalUserDarkFeature::getFeatureKey).collect(MoreCollectors.toImmutableSet());
        Set userEnabledFeatures = (Set)userDarkFeatures.getOrDefault(true, Collections.emptyList()).stream().map(InternalUserDarkFeature::getFeatureKey).collect(MoreCollectors.toImmutableSet());
        return new EnabledDarkFeaturesBuilder().featuresEnabledForCurrentUser(userEnabledFeatures).unmodifiableFeaturesEnabledForAllUsers(allUsersReadOnly).featuresEnabledForAllUsers((Set)Sets.difference((Set)allUsers, (Set)userDisabledFeatures).immutableCopy()).build();
    }

    @Override
    @Nonnull
    public Optional<Boolean> isEnabledForAnyUser(@Nonnull String featureKey) {
        if (ValidFeatureKeyPredicate.isValidFeatureKey((String)featureKey)) {
            return Optional.of(this.isEnabledForAllUsers(featureKey).orElse(false) != false || this.userDarkFeatureDao.existsByFeatureAndEnabled(featureKey, true));
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<Boolean> isEnabledForCurrentUser(@Nonnull String featureKey) {
        return this.isEnabledForUser(this.getCurrentUserKey(), featureKey);
    }

    @Nonnull
    public Optional<Boolean> isEnabledForUser(@Nullable UserKey userKey, @Nonnull String featureKey) {
        if (ValidFeatureKeyPredicate.isValidFeatureKey((String)featureKey)) {
            if (userKey == null) {
                return super.isEnabledForAllUsers(featureKey);
            }
            ApplicationUser user = this.userService.getUserById(ConfigurableDarkFeatureManager.getUserId(userKey));
            if (user == null) {
                throw new IllegalArgumentException(this.i18nService.getMessage("bitbucket.web.user.dark.feature.error.not.existing", new Object[]{userKey.getStringValue()}));
            }
            InternalUserDarkFeature internalUserDarkFeature = this.userDarkFeatureDao.getByUserAndFeature(ConfigurableDarkFeatureManager.getUserId(userKey), featureKey);
            if (internalUserDarkFeature != null) {
                return Optional.of(internalUserDarkFeature.isEnabled());
            }
            return super.isEnabledForAllUsers(featureKey);
        }
        return Optional.empty();
    }

    public boolean isFeatureEnabledForCurrentUser(String featureKey) {
        return this.isFeatureEnabledForUser(this.getCurrentUserKey(), featureKey);
    }

    public boolean isFeatureEnabledForUser(@Nullable UserKey userKey, String featureKey) {
        return this.isEnabledForUser(userKey, featureKey).orElse(false);
    }

    private static int getUserId(UserKey userKey) {
        return Integer.parseInt(userKey.getStringValue());
    }

    private UserKey getCurrentUserKey() {
        return this.userManager.getRemoteUserKey();
    }

    private void updateDarkFeature(UserKey userKey, String featureKey, boolean enabled) {
        ValidFeatureKeyPredicate.checkFeatureKey((String)featureKey);
        if (userKey == null) {
            throw new IllegalArgumentException(this.i18nService.getMessage("bitbucket.web.user.dark.feature.error.anonymous", new Object[0]));
        }
        ApplicationUser applicationUser = this.userService.getUserById(ConfigurableDarkFeatureManager.getUserId(userKey));
        if (applicationUser == null) {
            throw new IllegalArgumentException(this.i18nService.getMessage("bitbucket.web.user.dark.feature.error.not.existing", new Object[]{userKey.getStringValue()}));
        }
        UserKey currentUserKey = this.getCurrentUserKey();
        if (!(currentUserKey != null && currentUserKey.equals((Object)userKey) || this.userManager.isAdmin(currentUserKey) && !this.userManager.isSystemAdmin(userKey) || this.userManager.isSystemAdmin(currentUserKey))) {
            throw new MissingPermissionException(this.i18nService.getMessage("bitbucket.web.user.dark.feature.error.not.permitted", new Object[0]));
        }
        InternalUserDarkFeature userDarkFeature = this.userDarkFeatureDao.getByUserAndFeature(applicationUser.getId(), featureKey);
        if (userDarkFeature == null) {
            userDarkFeature = new InternalUserDarkFeature.Builder((InternalApplicationUser)applicationUser, featureKey).enabled(enabled).build();
            this.userDarkFeatureDao.create((Object)userDarkFeature);
        } else {
            InternalUserDarkFeature updated = new InternalUserDarkFeature.Builder(userDarkFeature).enabled(enabled).build();
            this.userDarkFeatureDao.update((Object)updated);
        }
    }
}

