/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.diagnostics;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.diagnostics.DiagnosticsConfiguration;
import com.atlassian.diagnostics.internal.DefaultDiagnosticsConfiguration;
import com.atlassian.diagnostics.internal.platform.monitor.event.EventSystemMonitorConfig;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=DiagnosticsConfiguration.class)
@Component(value="diagnosticsConfiguration")
public class ApplicationDiagnosticsConfiguration
extends DefaultDiagnosticsConfiguration
implements EventSystemMonitorConfig {
    private static final Logger log = LoggerFactory.getLogger(ApplicationDiagnosticsConfiguration.class);
    private final ClusterService clusterService;
    private final ThreadGroup eventThreadGroup;
    private final FeatureManager featureManager;
    private final Map<String, Duration> slowEventListenerAlertDurationByTrigger;
    private final Duration slowEventListenerDefaultAlertDuration;
    @Value(value="${diagnostics.alert.retention.time.minutes}")
    private long alertRetentionPeriodMinutes;
    @Value(value="${diagnostics.alert.truncation.interval.minutes}")
    private long alertTruncationIntervalMinutes;
    @Value(value="${diagnostics.issues.event.dropped.threaddump.cooldown.seconds}")
    private long eventDroppedAlertDetailCoolDown;

    @Autowired
    public ApplicationDiagnosticsConfiguration(@Lazy ClusterService clusterService, @Qualifier(value="eventThreadGroup") ThreadGroup eventThreadGroup, @Lazy FeatureManager featureManager, @Value(value="${diagnostics.issues.event.slow.listener.time.millis}") long slowEventListenerAlertMillis, @Value(value="${diagnostics.issues.event.slow.listener.internal.overrides}") String internalSlowListenerOverrides, @Value(value="${diagnostics.issues.event.slow.listener.overrides}") String slowListenerOverrides) {
        this.clusterService = clusterService;
        this.eventThreadGroup = eventThreadGroup;
        this.featureManager = featureManager;
        this.slowEventListenerDefaultAlertDuration = Duration.ofMillis(Math.max(250L, slowEventListenerAlertMillis));
        this.slowEventListenerAlertDurationByTrigger = ApplicationDiagnosticsConfiguration.parseSlowEventListenerOverrides(this.slowEventListenerDefaultAlertDuration, internalSlowListenerOverrides, slowListenerOverrides);
    }

    @Nonnull
    public Duration getAlertRetentionPeriod() {
        return Duration.ofMinutes(Math.max(0L, this.alertRetentionPeriodMinutes));
    }

    @Nonnull
    public Duration getAlertTruncationInterval() {
        return Duration.ofMinutes(Math.max(0L, this.alertTruncationIntervalMinutes));
    }

    @Nonnull
    public Duration getEventDroppedAlertThreadDumpCoolDown() {
        return Duration.ofSeconds(this.eventDroppedAlertDetailCoolDown);
    }

    @Nonnull
    public Optional<ThreadGroup> getEventThreadGroup() {
        return Optional.of(this.eventThreadGroup);
    }

    @Nonnull
    public String getNodeName() {
        ClusterNode node = this.clusterService.getInformation().getLocalNode();
        String name = node.getName();
        return StringUtils.isNotBlank((CharSequence)name) ? name : super.getNodeName();
    }

    @Nonnull
    public Duration getSlowListenerAlertDuration(AlertTrigger trigger) {
        if (trigger == null) {
            return this.slowEventListenerDefaultAlertDuration;
        }
        String pluginKey = trigger.getPluginKey();
        Duration result = trigger.getModule().map(module -> this.slowEventListenerAlertDurationByTrigger.get(pluginKey + "." + module)).orElseGet(() -> this.slowEventListenerAlertDurationByTrigger.get(pluginKey));
        return result == null ? this.slowEventListenerDefaultAlertDuration : result;
    }

    public boolean isEnabled() {
        return this.featureManager.isEnabled((Feature)StandardFeature.DIAGNOSTICS);
    }

    @Nonnull
    private static Map<String, Duration> parseSlowEventListenerOverrides(Duration minimumDuration, String ... whitelists) {
        HashMap<String, Duration> result = new HashMap<String, Duration>();
        Splitter splitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)",;\n")).trimResults().omitEmptyStrings();
        Splitter keyValueSplitter = Splitter.on((char)':').trimResults().omitEmptyStrings();
        for (String whitelist : whitelists) {
            splitter.split((CharSequence)whitelist).forEach(entry -> {
                try {
                    List keyAndValue = keyValueSplitter.splitToList((CharSequence)entry);
                    if (keyAndValue.size() == 2) {
                        Duration override = Duration.ofMillis(Long.valueOf((String)keyAndValue.get(1)));
                        if (override.compareTo(minimumDuration) > 0) {
                            result.compute((String)keyAndValue.get(0), (k, cur) -> {
                                if (cur == null || override.compareTo((Duration)cur) > 0) {
                                    return override;
                                }
                                log.debug("Ignoring slow event listener override '{}' because the current setting ({} ms) is more lenient", (Object)keyAndValue, (Object)cur.toMillis());
                                return cur;
                            });
                        } else {
                            log.debug("Ignoring slow event listener override '{}' because the default setting is more lenient", (Object)keyAndValue);
                        }
                    } else if (keyAndValue.size() == 1) {
                        log.warn("Ignoring invalid slow event listener override '{}'", keyAndValue.get(0));
                    }
                }
                catch (IllegalArgumentException e) {
                    log.warn("Ignoring invalid slow event listener override '{}'", entry, (Object)e);
                }
            });
        }
        return result;
    }
}

