/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.event.internal.InvokerTransformer;
import com.atlassian.event.spi.ListenerInvoker;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncBatchingInvokersTransformer
implements InvokerTransformer {
    private static final Logger log = LoggerFactory.getLogger(AsyncBatchingInvokersTransformer.class);
    private static final double LOG2 = Math.log(2.0);
    private static final Predicate<ListenerInvoker> SUPPORTS_ASYNC = ListenerInvoker::supportAsynchronousEvents;
    private final AtomicLong dispatchedCount = new AtomicLong();

    public long getDispatchedCount() {
        return this.dispatchedCount.get();
    }

    @Nonnull
    public Iterable<ListenerInvoker> transformAll(@Nonnull Iterable<ListenerInvoker> invokers, @Nonnull Object event) {
        int invokerCount = Iterables.size(invokers);
        this.dispatchedCount.addAndGet(invokerCount);
        boolean isAsyncEvent = this.isAsynchronousEvent(event);
        if (isAsyncEvent && invokerCount >= 2) {
            Iterable syncInvokers = Iterables.filter(invokers, (Predicate)Predicates.not(SUPPORTS_ASYNC));
            Iterable asyncInvokers = Iterables.filter(invokers, SUPPORTS_ASYNC);
            int asyncInvokerCount = Iterables.size((Iterable)asyncInvokers);
            int syncInvokerCount = invokerCount - asyncInvokerCount;
            double batchCount = Math.max(1.0, AsyncBatchingInvokersTransformer.log2(asyncInvokerCount));
            int batchSize = (int)Math.ceil((double)asyncInvokerCount / batchCount);
            Chainable asyncInvokerBatches = Chainable.chain((Iterable)asyncInvokers).partition(batchSize).transform(AsyncInvokerBatch::new);
            if (log.isTraceEnabled()) {
                log.trace("@AsynchronousPreferred event {}: {} async invoker batches (from {} original async invokers) and {} sync invokers to dispatch to", new Object[]{event.getClass().getName(), (asyncInvokerCount + 1) / batchSize, asyncInvokerCount, syncInvokerCount});
            }
            return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)asyncInvokerBatches, (Iterable)syncInvokers));
        }
        log.trace("{} event {}: {} invokers to dispatch to", new Object[]{isAsyncEvent ? "@AsynchronousPreferred" : "Synchronous", event.getClass().getName(), invokerCount});
        return invokers;
    }

    private boolean isAsynchronousEvent(Object event) {
        return Objects.requireNonNull(event, "event").getClass().getAnnotation(AsynchronousPreferred.class) != null;
    }

    private static double log2(int size) {
        return Math.log(size) / LOG2;
    }

    private static class AsyncInvokerBatch
    implements ListenerInvoker {
        private final Iterable<ListenerInvoker> invokers;

        public AsyncInvokerBatch(Iterable<ListenerInvoker> invokers) {
            this.invokers = invokers;
        }

        public Set<Class<?>> getSupportedEventTypes() {
            throw new UnsupportedOperationException("Unsupported for batched ListenerInvokers");
        }

        public void invoke(Object event) {
            for (ListenerInvoker invoker : this.invokers) {
                try {
                    invoker.invoke(event);
                }
                catch (Exception e) {
                    log.error("There was an exception thrown trying to dispatch event '{}' for the invoker '{}'", new Object[]{event, invoker, e});
                }
            }
        }

        public boolean supportAsynchronousEvents() {
            return true;
        }

        public String toString() {
            return "AsyncInvokerBatch{invokers=" + String.valueOf(this.invokers) + "}";
        }
    }
}

