/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.event.config.EventThreadPoolConfiguration;
import com.atlassian.stash.internal.utils.ExpressionUtils;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="eventThreadPoolConfiguration")
public class DefaultEventThreadPoolConfiguration
implements EventThreadPoolConfiguration {
    private final int corePoolSize;
    private final int maxPoolSize;
    private final long keepAliveTime;

    @Autowired
    public DefaultEventThreadPoolConfiguration(@Value(value="${event.dispatcher.core.threads}") String coreThreads, @Value(value="${event.dispatcher.keepAlive}") String keepAlive, @Value(value="${event.dispatcher.max.threads}") String maxThreads) {
        this.corePoolSize = ExpressionUtils.parseExpressionAsInt(coreThreads).orElse(4);
        this.keepAliveTime = ExpressionUtils.parseExpressionAsLong(keepAlive).orElse(60L);
        this.maxPoolSize = ExpressionUtils.parseExpressionAsInt(maxThreads).orElse(Runtime.getRuntime().availableProcessors());
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public TimeUnit getTimeUnit() {
        return TimeUnit.SECONDS;
    }
}

