/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.spi.ListenerHandler;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class EventListenerRegistrar
implements ApplicationListener<ContextRefreshedEvent>,
DestructionAwareBeanPostProcessor,
BeanFactoryAware,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(EventListenerRegistrar.class);
    private ConfigurableBeanFactory beanFactory;
    private EventPublisher eventPublisher;
    private final String eventPublisherName;
    private final Map<String, Object> toBeRegistered = Maps.newHashMap();
    private final ListenerHandlersConfiguration listenerHandlersConfiguration;
    private volatile boolean springContextRefreshed;

    public EventListenerRegistrar(String eventPublisherName, ListenerHandlersConfiguration listenerHandlersConfiguration) {
        this.eventPublisherName = eventPublisherName;
        this.listenerHandlersConfiguration = listenerHandlersConfiguration;
    }

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        this.springContextRefreshed = true;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.eventPublisher == null && beanName.equals(this.eventPublisherName)) {
            this.eventPublisher = (EventPublisher)bean;
            for (Object object : this.toBeRegistered.values()) {
                this.eventPublisher.register(object);
            }
            if (log.isTraceEnabled() && !this.toBeRegistered.isEmpty()) {
                log.trace("Registered [{}] as event listener", (Object)this.toBeRegistered.keySet().stream().collect(Collectors.joining(", ")));
            }
            this.toBeRegistered.clear();
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.eventPublisher == null) {
            this.toBeRegistered.remove(beanName);
        } else {
            this.eventPublisher.unregister(bean);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.springContextRefreshed) {
            return bean;
        }
        BeanDefinition beanDefinition = null;
        try {
            if (this.beanFactory != null) {
                beanDefinition = this.beanFactory.getMergedBeanDefinition(beanName);
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (beanDefinition == null || beanDefinition.isSingleton()) {
            this.registerBeanIfEventListener(beanName, bean);
        }
        return bean;
    }

    public boolean requiresDestruction(Object bean) {
        return this.eventPublisher != null || !this.toBeRegistered.isEmpty();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        }
    }

    private void registerBeanIfEventListener(String beanName, Object bean) {
        if (this.hasListenerHandler(bean)) {
            this.registerEventListener(beanName, bean);
        }
    }

    private boolean hasListenerHandler(Object bean) {
        if (bean == null) {
            return false;
        }
        for (ListenerHandler handler : this.listenerHandlersConfiguration.getListenerHandlers()) {
            if (handler.getInvokers(bean).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void registerEventListener(String beanName, Object bean) {
        if (this.eventPublisher != null) {
            log.trace("Registering {} as event listener", (Object)beanName);
            this.eventPublisher.register(bean);
        } else {
            this.toBeRegistered.put(beanName, bean);
        }
    }
}

