/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.event.config.EventThreadPoolConfiguration;
import com.atlassian.stash.internal.util.StackException;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventThreadPoolExecutor
extends ThreadPoolExecutor
implements RejectedExecutionHandler {
    private static final Logger log = LoggerFactory.getLogger(EventThreadPoolExecutor.class);
    private final Map<Runnable, Thread> activeThreads;
    private final RejectedExecutionHandler delegate;
    private final Executor logExecutor;
    private final long rejectionCooldown;
    private final AtomicLong rejectionCount;
    private final ThreadGroup threadGroup;
    private volatile long lastRejectionLogged;
    private volatile long lastRejectionTimestamp;

    public EventThreadPoolExecutor(EventThreadPoolConfiguration configuration, Executor logExecutor, ThreadFactory threadFactory, ThreadGroup threadGroup, int maxQueueSize, long rejectionCooldown, RejectedExecutionHandler delegate) {
        super(configuration.getCorePoolSize(), configuration.getMaximumPoolSize(), configuration.getKeepAliveTime(), configuration.getTimeUnit(), new LinkedBlockingQueue<Runnable>(maxQueueSize), threadFactory);
        this.logExecutor = logExecutor;
        this.rejectionCooldown = TimeUnit.MINUTES.toNanos(rejectionCooldown);
        this.threadGroup = threadGroup;
        this.activeThreads = new ConcurrentHashMap<Runnable, Thread>(configuration.getMaximumPoolSize(), 1.0f);
        this.delegate = delegate;
        this.rejectionCount = new AtomicLong();
        this.setRejectedExecutionHandler(this);
    }

    public Date getLastRejectionDate() {
        return this.lastRejectionTimestamp > 0L ? new Date(this.lastRejectionTimestamp) : null;
    }

    public long getRejectionCount() {
        return this.rejectionCount.get();
    }

    @Override
    public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
        this.lastRejectionTimestamp = System.currentTimeMillis();
        this.rejectionCount.incrementAndGet();
        if (this.threadGroup.equals(Thread.currentThread().getThreadGroup())) {
            this.logExecutor.execute(this::maybeLogThreads);
        } else {
            this.maybeLogThreads();
        }
        this.delegate.rejectedExecution(task, executor);
    }

    @Override
    protected void afterExecute(Runnable task, Throwable thrown) {
        this.activeThreads.remove(task);
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable task) {
        this.activeThreads.put(task, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeLogThreads() {
        long check = System.nanoTime();
        if (check - this.lastRejectionLogged > this.rejectionCooldown) {
            Map<Runnable, Thread> map = this.activeThreads;
            synchronized (map) {
                if (check - this.lastRejectionLogged > this.rejectionCooldown) {
                    this.lastRejectionLogged = System.nanoTime();
                    log.warn("The event queue is full. Stacks for the processing threads follow:");
                    for (Thread thread : ImmutableList.copyOf(this.activeThreads.values())) {
                        log.warn("Stack trace for {}", (Object)thread.getName(), (Object)new StackException(thread));
                    }
                }
            }
        }
    }
}

