/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.stash.internal.concurrent.CallerBlocksPolicy;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;

@Component(value="rejectedEventExecutionHandlerFactory")
public class RejectedEventExecutionHandlerFactory {
    private final RejectedEventPublishingStrategy rejectedEventPublishingStrategy;
    private final Duration rejectionBlockTimeout;

    public RejectedEventExecutionHandlerFactory(@Value(value="${event.dispatcher.queue.rejectionblocktimeout}") @DurationUnit(value=ChronoUnit.SECONDS) Duration rejectionBlockTimeout, @Value(value="${event.dispatcher.queue.rejectionhandlingstrategy}") String rejectionHandlingStrategy) {
        this.rejectionBlockTimeout = rejectionBlockTimeout;
        this.rejectedEventPublishingStrategy = RejectedEventPublishingStrategy.valueOf(rejectionHandlingStrategy.toUpperCase(Locale.ROOT));
    }

    @Nonnull
    public RejectedExecutionHandler create() {
        switch (this.rejectedEventPublishingStrategy.ordinal()) {
            case 2: {
                return new ThreadPoolExecutor.CallerRunsPolicy();
            }
            case 1: {
                return new CallerBlocksPolicy(this.rejectionBlockTimeout);
            }
        }
        return new ThreadPoolExecutor.AbortPolicy();
    }

    private static enum RejectedEventPublishingStrategy {
        DROP,
        BLOCK,
        IMMEDIATE;

    }
}

