/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.event.spi.ListenerInvoker;
import com.atlassian.stash.internal.event.SynchronousAwareSingleParameterMethodListenerInvoker;
import jakarta.annotation.Nonnull;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronousAwareAnnotatedMethodsListenerHandler<T extends Annotation>
implements ListenerHandler {
    private static final Logger log = LoggerFactory.getLogger(SynchronousAwareAnnotatedMethodsListenerHandler.class);
    private final Class<T> annotationClass;

    public SynchronousAwareAnnotatedMethodsListenerHandler() {
        this(EventListener.class);
    }

    public SynchronousAwareAnnotatedMethodsListenerHandler(@Nonnull Class<T> annotationClass) {
        this.annotationClass = Objects.requireNonNull(annotationClass);
    }

    @Nonnull
    public List<ListenerInvoker> getInvokers(@Nonnull Object listener) {
        Map<Method, EventListenerAnnotationParams> validMethods = this.getValidMethods(Objects.requireNonNull(listener));
        if (validMethods.isEmpty()) {
            log.trace("Couldn't find any valid listener methods on class <{}>", (Object)listener.getClass().getName());
        }
        return validMethods.entrySet().stream().map(entry -> new SynchronousAwareSingleParameterMethodListenerInvoker(listener, (Method)entry.getKey(), ((EventListenerAnnotationParams)entry.getValue()).scope, ((EventListenerAnnotationParams)entry.getValue()).order)).collect(Collectors.toCollection(LinkedList::new));
    }

    private EventListenerAnnotationParams getEventListenerAnnotationParams(Method method) {
        EventListener annotation = method.getAnnotation(EventListener.class);
        Optional<String> scope = Optional.ofNullable(annotation).map(EventListener::scope).filter(scopeName -> !scopeName.isEmpty());
        int order = annotation != null ? annotation.order() : 0;
        return new EventListenerAnnotationParams(scope, order);
    }

    private Map<Method, EventListenerAnnotationParams> getValidMethods(Object listener) {
        LinkedHashMap<Method, EventListenerAnnotationParams> annotatedMethods = new LinkedHashMap<Method, EventListenerAnnotationParams>();
        for (Method method : listener.getClass().getMethods()) {
            if (!this.isValidMethod(method)) continue;
            annotatedMethods.put(method, this.getEventListenerAnnotationParams(method));
        }
        return annotatedMethods;
    }

    private boolean hasOneAndOnlyOneParameter(Method method) {
        return method.getParameterTypes().length == 1;
    }

    private boolean isAnnotated(Method method) {
        return method.getAnnotation(this.annotationClass) != null;
    }

    private boolean isValidMethod(Method method) {
        if (this.isAnnotated(method)) {
            if (this.hasOneAndOnlyOneParameter(method)) {
                return true;
            }
            throw new RuntimeException("Method <" + String.valueOf(method) + "> of class <" + String.valueOf(method.getDeclaringClass()) + "> is annotated with <" + this.annotationClass.getName() + "> but has 0 or more than 1 parameters! Listener methods MUST have 1 and only 1 parameter.");
        }
        return false;
    }

    private static class EventListenerAnnotationParams {
        final int order;
        final Optional<String> scope;

        private EventListenerAnnotationParams(Optional<String> scope, int order) {
            this.scope = scope;
            this.order = order;
        }
    }
}

