/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.bitbucket.dmz.event.SynchronousListener;
import com.atlassian.event.spi.ListenerInvoker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SynchronousAwareSingleParameterMethodListenerInvoker
implements ListenerInvoker {
    private final Object listener;
    private final Method method;
    private final int order;
    private final Optional<String> scope;
    private final boolean synchronousListener;

    public SynchronousAwareSingleParameterMethodListenerInvoker(@Nonnull Object listener, @Nonnull Method method, @Nonnull Optional<String> scope, int order) {
        this.listener = Objects.requireNonNull(listener);
        this.synchronousListener = SynchronousAwareSingleParameterMethodListenerInvoker.isSynchronousMethod(listener, method);
        this.method = Objects.requireNonNull(method);
        this.scope = Objects.requireNonNull(scope);
        this.order = order;
    }

    @VisibleForTesting
    Object getListener() {
        return this.listener;
    }

    @VisibleForTesting
    Method getMethod() {
        return this.method;
    }

    public int getOrder() {
        return this.order;
    }

    @Nonnull
    public Optional<String> getScope() {
        return this.scope;
    }

    @Nonnull
    public Set<Class<?>> getSupportedEventTypes() {
        return Sets.newHashSet((Object[])this.method.getParameterTypes());
    }

    public void invoke(Object event) {
        try {
            this.method.invoke(this.listener, event);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(this.getInvocationErrorMessage(event), e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() == null) {
                throw new RuntimeException(this.getInvocationErrorMessage(event), e);
            }
            if (e.getCause().getMessage() == null) {
                throw new RuntimeException(this.getInvocationErrorMessage(event), e.getCause());
            }
            throw new RuntimeException(e.getCause().getMessage() + ". " + this.getInvocationErrorMessage(event), e.getCause());
        }
    }

    public boolean supportAsynchronousEvents() {
        return !this.synchronousListener;
    }

    public String toString() {
        return String.format("%s{method=%s, listener=%s, synchronous=%b}", this.getClass().getSimpleName(), this.method, this.paranoidToString(this.listener), this.synchronousListener);
    }

    private String getInvocationErrorMessage(Object event) {
        return "Listener: " + this.listener.getClass().getName() + " event: " + event.getClass().getName();
    }

    private String paranoidToString(Object object) {
        try {
            return String.valueOf(object);
        }
        catch (RuntimeException e) {
            return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
        }
    }

    private static boolean isSynchronousMethod(Object listener, Method method) {
        return listener.getClass().isAnnotationPresent(SynchronousListener.class) || method.isAnnotationPresent(SynchronousListener.class);
    }
}

