/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsDeletedEvent;
import com.atlassian.crowd.event.user.AutoUserCreatedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.util.ReflectionUtils;

public class TransactionAwareEventPublisher
implements EventPublisher {
    private static final Map<Class, TransactionAware.When> TRANSACTION_AWARE_OVERRIDES = ImmutableMap.builder().put(DirectoryUpdatedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(GroupDeletedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(GroupMembershipsCreatedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(GroupMembershipDeletedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(GroupMembershipsDeletedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(UserCreatedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(AutoUserCreatedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(UserDeletedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).put(UserUpdatedEvent.class, (Object)TransactionAware.When.AFTER_COMMIT).build();
    private static final Logger log = LoggerFactory.getLogger(TransactionAwareEventPublisher.class);
    private final AuthenticationContext authenticationContext;
    private final EventPublisher delegate;
    private final AtomicLong eventCount;
    private final TransactionSynchronizer synchronizer;
    private final Field userField;

    public TransactionAwareEventPublisher(AuthenticationContext authenticationContext, EventPublisher delegate, TransactionSynchronizer synchronizer) {
        this.authenticationContext = authenticationContext;
        this.delegate = delegate;
        this.synchronizer = synchronizer;
        this.eventCount = new AtomicLong();
        this.userField = TransactionAwareEventPublisher.getField("user");
    }

    public long getPublishedEventCount() {
        return this.eventCount.get();
    }

    public void publish(@Nonnull Object event) {
        this.setFields(Objects.requireNonNull(event, "event"));
        TransactionAware.When publishWhen = TransactionAwareEventPublisher.getTransactionConfiguration(event.getClass());
        if (publishWhen != null && publishWhen != TransactionAware.When.IMMEDIATE && this.synchronizer.register(this.createPublisher(publishWhen, event))) {
            log.debug("Deferring publishing for {} until {}", (Object)event.getClass().getSimpleName(), (Object)publishWhen);
            return;
        }
        this.internalPublish(event);
    }

    public void register(Object listener) {
        this.delegate.register(listener);
    }

    public void unregister(Object listener) {
        this.delegate.unregister(listener);
    }

    public void unregisterAll() {
        this.delegate.unregisterAll();
    }

    protected void setFields(Object event) {
        if (event instanceof ApplicationEvent && this.authenticationContext != null) {
            ReflectionUtils.setField((Field)this.userField, (Object)event, (Object)this.authenticationContext.getCurrentUser());
        }
    }

    protected static Field getField(String fieldName) {
        Field field = ReflectionUtils.findField(ApplicationEvent.class, (String)fieldName);
        ReflectionUtils.makeAccessible((Field)field);
        return field;
    }

    private static Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private static TransactionAware.When getTransactionConfiguration(Class eventClass) {
        TransactionAware annotation;
        TransactionAware.When publishWhen = TRANSACTION_AWARE_OVERRIDES.get(eventClass);
        if (publishWhen == null && (annotation = (TransactionAware)AnnotationUtils.findAnnotation((Class)eventClass, TransactionAware.class)) != null) {
            publishWhen = annotation.value();
        }
        return publishWhen;
    }

    private static void setAuthentication(Authentication authentication) {
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }

    private TransactionSynchronization createPublisher(TransactionAware.When publishWhen, Object event) {
        Authentication authentication = TransactionAwareEventPublisher.getAuthentication();
        switch (publishWhen) {
            case AFTER_COMMIT: {
                return new AfterCommitPublisher(event, authentication);
            }
            case AFTER_COMPLETION: {
                return new AfterCompletionPublisher(event, authentication);
            }
        }
        throw new IllegalArgumentException(String.valueOf(publishWhen) + " is not a known publishing point");
    }

    private void internalPublish(Object event) {
        this.eventCount.incrementAndGet();
        this.delegate.publish(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalPublish(Object event, Authentication authentication) {
        Authentication previous = TransactionAwareEventPublisher.getAuthentication();
        try {
            TransactionAwareEventPublisher.setAuthentication(authentication);
            this.internalPublish(event);
        }
        finally {
            TransactionAwareEventPublisher.setAuthentication(previous);
        }
    }

    private class AfterCommitPublisher
    extends TransactionSynchronizationAdapter {
        private final Authentication authentication;
        private final Object event;

        public AfterCommitPublisher(@Nullable Object event, Authentication authentication) {
            this.event = event;
            this.authentication = authentication;
        }

        public void afterCompletion(int status) {
            if (status == 0) {
                TransactionAwareEventPublisher.this.synchronizer.setReadOnly(true);
                log.debug("Publishing {} after commit", (Object)this.event.getClass().getSimpleName());
                TransactionAwareEventPublisher.this.internalPublish(this.event, this.authentication);
            } else {
                log.trace("Discarding {}; the transaction was not committed (Status: {})", (Object)this.event.getClass().getSimpleName(), (Object)status);
            }
        }
    }

    private class AfterCompletionPublisher
    extends TransactionSynchronizationAdapter {
        private final Authentication authentication;
        private final Object event;

        public AfterCompletionPublisher(@Nullable Object event, Authentication authentication) {
            this.event = event;
            this.authentication = authentication;
        }

        public void afterCompletion(int status) {
            TransactionAwareEventPublisher.this.synchronizer.setReadOnly(true);
            log.debug("Publishing {} after completion (Status: {})", (Object)this.event.getClass().getSimpleName(), (Object)status);
            TransactionAwareEventPublisher.this.internalPublish(this.event, this.authentication);
        }
    }
}

