/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.help;

import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.util.UrlUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.UriUtils;

public abstract class AbstractHelpPathService
implements HelpPathService {
    protected abstract String getProperty(String var1);

    public String getPageAlt(String topicKey) {
        return topicKey == null ? null : this.getProperty(topicKey + ".alt");
    }

    public String getPageKey(String topicKey) {
        return topicKey == null ? null : this.getProperty(topicKey);
    }

    public String getPageTitle(String topicKey) {
        return topicKey == null ? null : this.getProperty(topicKey + ".title");
    }

    public String getPageUrl(String topicKey) {
        String helpPrefix = this.getPrefix(topicKey);
        String helpPageKey = this.getPageKey(topicKey);
        if (helpPrefix == null || helpPageKey == null) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        String[] urlParts = helpPageKey.split("\\?|#", 2);
        if (urlParts.length > 1) {
            if (helpPageKey.contains("?")) {
                String[] queryParts = urlParts[1].split("#");
                query.append(this.getQueryParams(queryParts[0]));
                if (queryParts.length > 1) {
                    query.append('#');
                    query.append(queryParts[1]);
                }
            } else {
                query.append(this.getQueryParams(""));
                query.append('#');
                query.append(urlParts[1]);
            }
        } else {
            query.append(this.getQueryParams(""));
        }
        String completePath = this.encode(helpPrefix, urlParts[0]);
        return String.format("%s%s", completePath, query.toString());
    }

    private String encode(String baseUrl, String relativePath) {
        String completePath = String.format("%s/%s", baseUrl, relativePath);
        if (this.isAlreadyEncoded(relativePath)) {
            return completePath;
        }
        return UriUtils.encodePath((String)completePath, (Charset)StandardCharsets.UTF_8);
    }

    private boolean isAlreadyEncoded(String urlPart) {
        try {
            String decodedUrl = UrlUtils.decodeURL((String)urlPart);
            return !urlPart.equals(decodedUrl);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public String getPrefix() {
        return this.getProperty("bitbucket.help.prefix");
    }

    private String getPrefix(String topicKey) {
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"bitbucket.kb.")) {
            return this.getProperty("bitbucket.kb.prefix");
        }
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"bitbucket.wac.")) {
            return this.getProperty("bitbucket.wac.prefix");
        }
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"bitbucket.go.")) {
            return this.getProperty("bitbucket.go.prefix");
        }
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"bitbucket.dac.")) {
            return this.getProperty("bitbucket.dac.prefix");
        }
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"bitbucket.jac.")) {
            return this.getProperty("bitbucket.jac.prefix");
        }
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"bitbucket.cloud.help.")) {
            return this.getProperty("bitbucket.cloud.help.prefix");
        }
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"embedded.crowd.support.")) {
            return this.getProperty("embedded.crowd.support.prefix");
        }
        if (StringUtils.startsWith((CharSequence)topicKey, (CharSequence)"bitbucket.confluence.")) {
            return this.getProperty("bitbucket.confluence.prefix");
        }
        return this.getPrefix();
    }

    private String getQueryParams(String helpQueryParams) {
        String queryString = this.getProperty("bitbucket.help.analytics.tracking");
        Map params = UrlUtils.splitQuery((String)queryString);
        return "?" + UrlUtils.setQueryParams((String)helpQueryParams, (Map)params);
    }
}

