/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.home.DefaultEnvironmentVariableResolver;
import com.atlassian.stash.internal.home.EnvironmentVariableResolver;
import com.atlassian.stash.internal.home.HomeSubdirectoryResolver;
import com.atlassian.stash.internal.home.UnsupportedDirectoryOverrideException;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;

public class DefaultHomeSubdirectoryResolver
implements HomeSubdirectoryResolver {
    private static final String SYSTEM_PROPERTY_PREFIX = "stash.home.";
    private static final String ENVIRONMENT_VARIABLE_PREFIX = "STASH_HOME_";
    private final EnvironmentVariableResolver environmentVariableResolver;

    public DefaultHomeSubdirectoryResolver() {
        this(new DefaultEnvironmentVariableResolver());
    }

    public DefaultHomeSubdirectoryResolver(EnvironmentVariableResolver environmentVariableResolver) {
        this.environmentVariableResolver = environmentVariableResolver;
    }

    @Override
    @Nonnull
    public Path create(@Nonnull Path parent, @Nonnull String name) {
        return MoreFiles.mkdir((Path)parent, (String)name);
    }

    @Override
    public String getOverride(@Nonnull String name) {
        boolean isNotTmp = !name.equals("tmp");
        String envVariableName = ENVIRONMENT_VARIABLE_PREFIX + name.toUpperCase();
        String envVariableValue = this.environmentVariableResolver.getValue(envVariableName);
        if (StringUtils.isNotEmpty((CharSequence)envVariableValue) && isNotTmp) {
            throw new UnsupportedDirectoryOverrideException("Overriding %s directory location using %s environment variable is no longer supported", name, envVariableName);
        }
        String propertyName = SYSTEM_PROPERTY_PREFIX + name;
        String propertyValue = System.getProperty(propertyName, envVariableValue);
        if (StringUtils.isNotEmpty((CharSequence)propertyValue) && isNotTmp) {
            throw new UnsupportedDirectoryOverrideException("Overriding %s directory location using %s system property is no longer supported", name, propertyName);
        }
        return propertyValue;
    }

    @Override
    @Nonnull
    public Path resolve(@Nonnull Path parent, @Nonnull String name) {
        String override = this.getOverride(name);
        return MoreFiles.mkdir((Path)(override == null ? parent.resolve(name) : Paths.get(override, new String[0])));
    }
}

