/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.bitbucket.Product;
import com.atlassian.stash.internal.home.DefaultEnvironmentVariableResolver;
import com.atlassian.stash.internal.home.EnvironmentVariableResolver;
import com.atlassian.stash.internal.home.HomeDirectoryDetails;
import com.atlassian.stash.internal.home.InvalidHomeDirectoryException;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;

public class HomeDirectoryResolver {
    static final String ENV_HOME = "BITBUCKET_HOME";
    static final String ENV_LEGACY_HOME = "STASH_HOME";
    static final String ENV_LEGACY_SHARED_HOME = "STASH_SHARED_HOME";
    static final String ENV_SHARED_HOME = "BITBUCKET_SHARED_HOME";
    private final EnvironmentVariableResolver environmentVariableResolver;

    public HomeDirectoryResolver() {
        this(new DefaultEnvironmentVariableResolver());
    }

    public HomeDirectoryResolver(@Nonnull EnvironmentVariableResolver environmentVariableResolver) {
        this.environmentVariableResolver = environmentVariableResolver;
    }

    @Nonnull
    public HomeDirectoryDetails resolve() {
        Path home = this.resolveHomeDir();
        Path sharedHome = this.resolveSharedHomeDir(home);
        return new HomeDirectoryDetails(home, sharedHome);
    }

    @Nonnull
    public HomeDirectoryDetails resolveAndValidate() {
        HomeDirectoryDetails details = this.resolve();
        HomeDirectoryResolver.checkNotInInstallDir(details.getHome(), "home");
        HomeDirectoryResolver.checkNotInInstallDir(details.getSharedHome(), "shared home");
        return details;
    }

    private static void checkNotInInstallDir(Path directory, String directoryName) {
        String value = System.getProperty("bitbucket.install");
        if (value == null) {
            return;
        }
        Path installDir = HomeDirectoryResolver.resolve(value);
        if (directory.startsWith(installDir)) {
            throw new InvalidHomeDirectoryException("The %s directory [%s] must not be the same directory as or a subdirectory of the %s installation directory.", directoryName, directory.toAbsolutePath(), Product.NAME);
        }
    }

    private static void checkTilde(String text, String directoryName) {
        if (text != null && text.startsWith("~")) {
            throw new IllegalStateException("The " + directoryName + " directory [" + text + "] is invalid; tilde expansion is not supported. Use an absolute path referring to a specific home directory.");
        }
    }

    private static Path resolve(String dirName) {
        Path dir = Paths.get(dirName, new String[0]);
        try {
            return dir.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return dir.toAbsolutePath();
        }
    }

    private String getPropertyValue(VariableBundle bundle, Supplier<String> missingValueSupplier) {
        String propertyValue = System.getProperty(bundle.getSystem());
        if (propertyValue != null) {
            System.setProperty(bundle.getLegacySystem(), propertyValue);
            return propertyValue;
        }
        propertyValue = this.environmentVariableResolver.getValue(bundle.getEnvironment());
        if (propertyValue == null && (propertyValue = System.getProperty(bundle.getLegacySystem())) == null) {
            propertyValue = this.environmentVariableResolver.getValue(bundle.getLegacyEnvironment());
        }
        if (propertyValue == null && missingValueSupplier != null) {
            propertyValue = missingValueSupplier.get();
        }
        if (propertyValue != null) {
            System.setProperty(bundle.getLegacySystem(), propertyValue);
            System.setProperty(bundle.getSystem(), propertyValue);
        }
        return propertyValue;
    }

    private Path resolveHomeDir() {
        String home = this.getPropertyValue(VariableBundle.HOME, null);
        Preconditions.checkState((home != null ? 1 : 0) != 0, (String)"No home directory is defined using either the system property '%s' or the environment variable '%s'", (Object)"bitbucket.home", (Object)ENV_HOME);
        HomeDirectoryResolver.checkTilde(home, "home");
        return HomeDirectoryResolver.resolve(home);
    }

    private Path resolveSharedHomeDir(Path home) {
        String sharedHome = this.getPropertyValue(VariableBundle.SHARED_HOME, () -> home.resolve("shared").toString());
        Preconditions.checkState((sharedHome != null ? 1 : 0) != 0, (Object)"Cannot derive shared home value from home value");
        HomeDirectoryResolver.checkTilde(sharedHome, "shared home");
        return HomeDirectoryResolver.resolve(sharedHome);
    }

    private static enum VariableBundle {
        HOME("BITBUCKET_HOME", "STASH_HOME", "bitbucket.home", "stash.home"),
        SHARED_HOME("BITBUCKET_SHARED_HOME", "STASH_SHARED_HOME", "bitbucket.shared.home", "stash.shared.home");

        private final String environment;
        private final String legacyEnvironment;
        private final String legacySystem;
        private final String system;

        private VariableBundle(String environment, String legacyEnvironment, String system, String legacySystem) {
            this.environment = environment;
            this.legacyEnvironment = legacyEnvironment;
            this.legacySystem = legacySystem;
            this.system = system;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getLegacyEnvironment() {
            return this.legacyEnvironment;
        }

        public String getLegacySystem() {
            return this.legacySystem;
        }

        public String getSystem() {
            return this.system;
        }
    }
}

